% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexbin.R
\name{hexbinOptions}
\alias{hexbinOptions}
\title{hexbinOptions}
\usage{
hexbinOptions(
  duration = 200,
  colorScaleExtent = NULL,
  radiusScaleExtent = NULL,
  colorRange = c("#f7fbff", "#08306b"),
  radiusRange = c(5, 15),
  pointerEvents = "all",
  resizetoCount = FALSE,
  tooltip = "Count "
)
}
\arguments{
\item{duration}{Transition duration for the hexbin layer}

\item{colorScaleExtent}{extent of the color scale for the hexbin layer. This
is used to override the derived extent of the color values and is specified
as a vector of the form c(min= numeric, max= numeric). Can be a numeric
vector or a custom \code{\link[htmlwidgets]{JS}} array, like
(\code{JS("[40, undefined]")})}

\item{radiusScaleExtent}{This is the same exact configuration option as
colorScaleExtent, only applied to the radius extent.}

\item{colorRange}{Sets the range of the color scale used to fill the hexbins
on the layer.}

\item{radiusRange}{Sets the range of the radius scale used to size the
hexbins on the layer.}

\item{pointerEvents}{This value is passed directly to an element-level css
style for pointer-events. You should only modify this config option if you
want to change the mouse event behavior on hexbins. This will modify when
the events are propagated based on the visibility state and/or part of the
hexbin being hovered.}

\item{resizetoCount}{Resizes the hexbin to the count. Default is
\code{FALSE}. If set to \code{TRUE} it will resize based on the amount of
underlying elements. You can also pass a custom
\code{\link[htmlwidgets]{JS}} function.}

\item{tooltip}{Should tooltips be displayed? If set to \code{TRUE}, it will
show the amount of underlying elements. If a string is given, it will
append the string before the count. To disable tooltips, please pass
\code{NULL} or \code{FALSE}. You can also pass a custom
\code{\link[htmlwidgets]{JS}} function.}
}
\value{
A list of hexbin-specific options
}
\description{
A list of options for customizing the appearance/behavior of the hexbin layer.
}
\seealso{
Other Hexbin-D3 Functions: 
\code{\link{addHexbin}()},
\code{\link{clearHexbin}()},
\code{\link{hideHexbin}()},
\code{\link{showHexbin}()},
\code{\link{updateHexbin}()}
}
\concept{Hexbin-D3 Functions}
