% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movingmarker.R
\name{addMovingMarker}
\alias{addMovingMarker}
\title{Add Moving Markers}
\usage{
addMovingMarker(
  map,
  lng = NULL,
  lat = NULL,
  layerId = NULL,
  group = NULL,
  duration = 2000,
  icon = NULL,
  popup = NULL,
  popupOptions = NULL,
  label = NULL,
  labelOptions = NULL,
  movingOptions = movingMarkerOptions(),
  options = leaflet::markerOptions(),
  data = leaflet::getMapData(map)
)
}
\arguments{
\item{map}{the map to add moving markers}

\item{lng}{a numeric vector of longitudes, or a one-sided formula of the form
\code{~x} where \code{x} is a variable in \code{data}; by default (if not
explicitly provided), it will be automatically inferred from \code{data} by
looking for a column named \code{lng}, \code{long}, or \code{longitude}
(case-insensitively)}

\item{lat}{a vector of latitudes or a formula (similar to the \code{lng}
argument; the names \code{lat} and \code{latitude} are used when guessing
the latitude column from \code{data})}

\item{layerId}{In order to be able to address the moving markings
individually, a layerId is required. If none is specified, one is created
that is derived from the current timestamp.}

\item{group}{the name of the group the newly created layers should belong to
(for \code{\link[leaflet]{clearGroup}} and \code{\link[leaflet]{addLayersControl}} purposes).
Human-friendly group names are permitted--they need not be short,
identifier-style names. Any number of layers and even different types of
layers (e.g. markers and polygons) can share the same group name.}

\item{duration}{Duration in milliseconds per line segment between 2 points.
Can be a vector or a single number. Default is \code{1000}}

\item{icon}{the icon(s) for markers;}

\item{popup}{a character vector of the HTML content for the popups (you are
recommended to escape the text using \code{\link[htmltools]{htmlEscape}()}
for security reasons)}

\item{popupOptions}{A Vector of \code{\link[leaflet]{popupOptions}} to provide popups}

\item{label}{a character vector of the HTML content for the labels}

\item{labelOptions}{A Vector of \code{\link[leaflet]{labelOptions}} to provide label
options for each label. Default \code{NULL}}

\item{movingOptions}{a list of extra options for moving markers.
See \code{\link{movingMarkerOptions}}}

\item{options}{a list of extra options for markers. See
\code{\link[leaflet]{markerOptions}}}

\item{data}{the data object from which the argument values are derived; by
default, it is the \code{data} object provided to \code{leaflet()}
initially, but can be overridden}
}
\value{
the new \code{map} object
}
\description{
The function expects either line or point data as spatial data or as Simple Feature.
Alternatively, coordinates can also be passed as numeric vectors.
}
\examples{
library(sf)
library(leaflet)
library(leaflet.extras2)

df <- sf::st_as_sf(atlStorms2005)[1,]
leaflet()  \%>\%
  addTiles() \%>\%
  addPolylines(data = df) \%>\%
  addMovingMarker(data = df,
                  movingOptions = movingMarkerOptions(autostart = TRUE, loop = TRUE),
                  label="I am a pirate!",
                  popup="Arrr")

}
\references{
\url{https://github.com/ewoken/Leaflet.MovingMarker}
}
\seealso{
Other MovingMarker Functions: 
\code{\link{movingMarkerOptions}()},
\code{\link{startMoving}()}
}
\concept{MovingMarker Functions}
