% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/history.R
\name{addHistory}
\alias{addHistory}
\title{Add History Plugin}
\usage{
addHistory(map, layerId = NULL, options = historyOptions())
}
\arguments{
\item{map}{a map widget object created from \code{\link[leaflet]{leaflet}}}

\item{layerId}{the control id}

\item{options}{A named list of options. See \code{\link{historyOptions}}}
}
\value{
the new \code{map} object
}
\description{
The plugin enables tracking of map movements in a history similar to a web
browser. By default, it is a simple pair of buttons -- back and forward.
}
\examples{
library(leaflet)
leaflet()  \%>\%
  addTiles() \%>\%
  addHistory()
}
\references{
\url{https://github.com/cscott530/leaflet-history}
}
\seealso{
Other History Functions: 
\code{\link{clearFuture}()},
\code{\link{clearHistory}()},
\code{\link{goBackHistory}()},
\code{\link{goForwardHistory}()},
\code{\link{historyOptions}()}
}
\concept{History Functions}
