% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend.R
\name{legendSymbols}
\alias{legendSymbols}
\alias{addLegendSize}
\alias{addLegendLine}
\alias{addLegendSymbol}
\title{Add a legend for the sizing of symbols or the width of lines}
\usage{
addLegendSize(
  map,
  pal,
  values,
  title = NULL,
  labelStyle = "",
  shape = c("rect", "circle", "triangle", "plus", "cross", "diamond", "star",
    "stadium", "polygon"),
  orientation = c("vertical", "horizontal"),
  color,
  fillColor = color,
  strokeWidth = 1,
  opacity = 1,
  fillOpacity = opacity,
  breaks = 5,
  baseSize = 20,
  numberFormat = function(x) {
     prettyNum(x, big.mark = ",", scientific = FALSE,
    digits = 1)
 },
  group = NULL,
  className = "info legend leaflet-control",
  data = leaflet::getMapData(map),
  ...
)

addLegendLine(
  map,
  pal,
  values,
  title = NULL,
  labelStyle = "",
  orientation = c("vertical", "horizontal"),
  width = 20,
  color,
  opacity = 1,
  fillOpacity = opacity,
  breaks = 5,
  baseSize = 10,
  numberFormat = function(x) {
     prettyNum(x, big.mark = ",", scientific = FALSE,
    digits = 1)
 },
  group = NULL,
  className = "info legend leaflet-control",
  data = leaflet::getMapData(map),
  ...
)

addLegendSymbol(
  map,
  pal,
  values,
  title = NULL,
  labelStyle = "",
  shape = c("rect", "circle", "triangle", "plus", "cross", "diamond", "star",
    "stadium", "polygon"),
  orientation = c("vertical", "horizontal"),
  color,
  fillColor = color,
  strokeWidth = 1,
  opacity = 1,
  fillOpacity = opacity,
  width = 20,
  height = width,
  group = NULL,
  className = "info legend leaflet-control",
  data = leaflet::getMapData(map),
  ...
)
}
\arguments{
\item{map}{a map widget object created from 'leaflet'}

\item{pal}{the color palette function, generated from \link[leaflet]{colorNumeric}}

\item{values}{the values used to generate sizes and if colorValues is not specified and
pal is given, then the values are used to generate  colors from the palette
function}

\item{title}{the legend title, pass in HTML to style}

\item{labelStyle}{character string of style argument for HTML text}

\item{shape}{shape of the color symbols}

\item{orientation}{stack the legend items vertically or horizontally}

\item{color}{the color of the legend symbols, if omitted pal is used}

\item{fillColor}{fill color of symbol}

\item{strokeWidth}{width of symbol outline}

\item{opacity}{opacity of the legend items}

\item{fillOpacity}{fill opacity of the legend items}

\item{breaks}{an integer specifying the number of breaks or a numeric vector of the breaks}

\item{baseSize}{re-scaling size in pixels of the mean of the values, the average value will
be this exact size}

\item{numberFormat}{formatting functions for numbers that are displayed e.g. format, prettyNum}

\item{group}{group name of a leaflet layer group}

\item{className}{extra CSS class to append to the control, space separated}

\item{data}{a data object. Currently supported objects are matrices, data
frames, spatial objects from the \pkg{sp} package
(\code{SpatialPoints}, \code{SpatialPointsDataFrame}, \code{Polygon},
\code{Polygons}, \code{SpatialPolygons}, \code{SpatialPolygonsDataFrame},
\code{Line}, \code{Lines}, \code{SpatialLines}, and
\code{SpatialLinesDataFrame}), and
spatial data frames from the \pkg{sf} package.}

\item{...}{arguments to pass to

\link[leaflet]{addControl} for addLegendSize

\link[base]{pretty} for sizeBreaks

\link[leaflegend]{makeSymbol} for makeSymbolsSize}

\item{width}{width in pixels of the lines}

\item{height}{in pixels}
}
\value{
an object from \link[leaflet]{addControl}
}
\description{
Add a legend for the sizing of symbols or the width of lines
}
\examples{
library(leaflet)
data("quakes")
quakes <- quakes[1:100,]
numPal <- colorNumeric('viridis', quakes$depth)
sizes <- sizeNumeric(quakes$depth, baseSize = 10)
symbols <- Map(
  makeSymbol,
  shape = 'triangle',
  color = numPal(quakes$depth),
  width = sizes,
  height = sizes
)
leaflet() \%>\%
  addTiles() \%>\%
  addMarkers(data = quakes,
             icon = icons(iconUrl = symbols),
             lat = ~lat, lng = ~long) \%>\%
  addLegendSize(
    values = quakes$depth,
    pal = numPal,
    title = 'Depth',
    labelStyle = 'margin: auto;',
    shape = c('triangle'),
    orientation = c('vertical', 'horizontal'),
    opacity = .7,
    breaks = 5)

# a wrapper for making icons is provided
sizeSymbols <-
makeSymbolsSize(
  quakes$depth,
  shape = 'cross',
  fillColor = numPal(quakes$depth),
  color = 'black',
  strokeWidth = 1,
  opacity = .8,
  fillOpacity = .5,
  baseSize = 20
)
leaflet() \%>\%
  addTiles() \%>\%
  addMarkers(data = quakes,
             icon = sizeSymbols,
             lat = ~lat, lng = ~long) \%>\%
  addLegendSize(
    values = quakes$depth,
    pal = numPal,
    title = 'Depth',
    shape = 'cross',
    orientation = 'horizontal',
    strokeWidth = 1,
    opacity = .8,
    fillOpacity = .5,
    color = 'black',
    baseSize = 20,
    breaks = 5)

# Group layers control
leaflet() \%>\%
  addTiles() \%>\%
    addLegendSize(
      values = quakes$depth,
      pal = numPal,
      title = 'Depth',
      labelStyle = 'margin: auto;',
      shape = c('triangle'),
      orientation = c('vertical', 'horizontal'),
      opacity = .7,
      breaks = 5,
      group = 'Depth') \%>\%
    addLayersControl(overlayGroups = c('Depth'))

# Polyline Legend for Size
baseSize <- 10
lineColor <- '#00000080'
pal <- colorNumeric('Reds', atlStorms2005$MinPress)
leaflet() \%>\%
  addTiles() \%>\%
  addPolylines(data = atlStorms2005,
               weight = ~sizeNumeric(values = MaxWind, baseSize = baseSize),
               color = ~pal(MinPress),
               popup = ~as.character(MaxWind)) \%>\%
  addLegendLine(values = atlStorms2005$MaxWind,
                title = 'MaxWind',
                baseSize = baseSize,
                width = 50,
                color = lineColor) \%>\%
  addLegendNumeric(pal = pal,
                   title = 'MinPress',
                   values = atlStorms2005$MinPress)
}
