% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{get.options.pca}
\alias{get.options.pca}
\title{Get Options for PCA}
\usage{
get.options.pca(ignoreFirst = 1, exactCount = 0, cutoffRate = 0.8, max = 1000)
}
\arguments{
\item{ignoreFirst}{A number representing the number of variables to exclude at the beginning of data matrices (such as intercept) from PCA.}

\item{exactCount}{A number that determines the number of components to be used. If zero, the number of components is determined by the \code{cutoffRate}.}

\item{cutoffRate}{A number between 0 and 1 that determines the cutoff rate for the cumulative variance ratio in order to determine the number of PCA components. It is not used if \code{exactCount} is positive.}

\item{max}{A number representing the maximum number of components when \code{cutoffRate} is used.}
}
\value{
A list with the given options.
}
\description{
Use this function to get PCA options in \link{estim.bin}, \link{estim.sur}, \link{estim.varma}, or \link{s.pca} functions.
}
\details{
See details of \link{s.pca} function.
}
\examples{
# See 's.pca' function.

}
\seealso{
\link{estim.bin}, \link{estim.sur}, \link{estim.varma}, \link{s.pca}
}
