% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r-func.R
\name{search.rfunc}
\alias{search.rfunc}
\title{Create a Model Set for an R Function}
\usage{
search.rfunc(
  data = get.data(),
  combinations = get.combinations(),
  metrics = get.search.metrics(),
  modelChecks = get.search.modelchecks(),
  items = get.search.items(),
  options = get.search.options(),
  rFuncName,
  length1,
  isInnerExogenous
)
}
\arguments{
\item{data}{A list that determines data and other required information for the search process.
Use \code{\link[=get.data]{get.data()}} function to generate it from a \code{matrix} or a \code{data.frame}.}

\item{combinations}{A list that determines the combinations of endogenous and exogenous variables in the search process.
Use \code{\link[=get.combinations]{get.combinations()}} function to define it.}

\item{metrics}{A list of options for measuring performance.
Use \link{get.search.metrics} function to get them.}

\item{modelChecks}{A list of options for excluding a subset of the model set.
See and use \link{get.search.modelchecks} function to get them.}

\item{items}{A list of options for specifying the purpose of the search.
See and use \link{get.search.items} function to get them.}

\item{options}{A list of extra options for performing the search.
See and use \link{get.search.options} function to get them.}

\item{rFuncName}{Name of a function that uses column indices and number of endogenous variables with respect to \code{data}.
It should estimate a model and return a list with required performance statistics. See details.}

\item{length1}{An integer for the length of requested information. This can be the number of exogenous variables.}

\item{isInnerExogenous}{If \code{TRUE}, exogenous indices are defined by \code{innerGroups} in the \code{combinations} argument.}
}
\value{
A nested list with the following members:
\item{counts}{Information about the expected number of models, number of estimated models, failed estimations, and some details about the failures.}
\item{results}{A data frame with requested information in \code{items} list.}
\item{info}{The arguments and some general information about the search process such as the elapsed time.}

Note that the output does not contain any estimation results, but minimum required data to estimate the models (Use \code{summary()} function to get the estimation).
}
\description{
Use this model to create a model set for an R function.
}
\details{
The central part of calling this function is to write a function with \code{rFuncName} name.
This function must have the following arguments:
\itemize{
\item \code{columnIndices}: determines the variables to be used in the current iteration. These indices point to the column of \code{data$data} matrix. E.g., you can create a matrix of available data by using \code{data$data[,colIndices]}. It contains weight column index (at \code{numEndo+1}), if \code{data$hasWeight} is \code{TRUE}.
\item \code{numEndo}: can be used to divide the \code{columnIndices} into endogenous and exogenous indices.
\item \code{data, metrics, modelChecks, items}: The arguments of current function which are passed to this function.
}

The \code{rFuncName} function should use these arguments and estimate or predict by using any available R function.

This function must return a \code{List} with the following items:
\itemize{
\item \code{error} (Character string or NULL): It not \code{NULL} or empty, it is considered as a failed estimation with the given message.
\item \code{metrics} (Numeric Matrix): Model performance for each target variable. Available target variables must be in the columns and metrics in the rows.
\item \code{extra} (Numeric Vector or NULL): Extra information in form of integers, which defines the current model.
\item \code{type1means} (Numeric Matrix or NULL): Means of \code{type1} (coefficients or predictions) for each target variable. Target variables must be in the columns. Make sure to skip the rows which the model does not present any information.
\item \code{type1vars} (Numeric Matrix or NULL): similar to \code{type1means} but for reporting the variances.
}
}
