% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{latex.matrix}
\alias{latex.matrix}
\title{Convert a matrix to LaTeX code}
\usage{
latex.matrix(mat, env = "bmatrix", numFormat = "\%.2f")
}
\arguments{
\item{mat}{A matrix to convert to LaTeX code.}

\item{env}{A character string specifying the matrix environment to use.
Possible values are "bmatrix", "pmatrix", "Bmatrix", "vmatrix", and "Vmatrix".}

\item{numFormat}{A character string specifying the format to use when displaying the numbers.
This value can be any valid format string accepted by the sprintf function.}
}
\value{
A character string containing the LaTeX code for the matrix.
}
\description{
This function takes a matrix and returns the LaTeX code for the matrix,
using the specified matrix environment and number format.
}
\examples{
#mat <- matrix(1:4, ncol = 2)
#latex.matrix(mat)
#latex.matrix(mat, env = "pmatrix")
#latex.matrix(mat, numFormat = "\%.0f")
}
