% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{fan.plot}
\alias{fan.plot}
\title{Create a fan plot from a matrix of distribution parameters}
\usage{
fan.plot(
  data,
  dist = "normal",
  quantiles = c(0.05, 0.1, 0.25, 0.75, 0.9, 0.95),
  gradient = FALSE,
  gradPointShape = 19,
  limExpand = c(0.1, 0.1),
  new.plot = TRUE,
  boundColor = "blue",
  midColor = "black",
  ...
)
}
\arguments{
\item{data}{A matrix with n columns where each row represents a prediction as a probability distribution.}

\item{dist}{The type of distribution to use: "normal" or "log-normal".}

\item{quantiles}{A list of quantiles to plot.}

\item{gradient}{Logical value indicating whether to add a gradient plot from the median to the minimum and maximum \code{quantiles}.}

\item{gradPointShape}{The shape of the point to use when gradient is TRUE.}

\item{limExpand}{A multiplier to to expand the range of the y-axis.}

\item{new.plot}{Logical value indicating whether to create a new plot or use the current plot.}

\item{boundColor}{The color to use for the bounds around the median.}

\item{midColor}{The color to use for the median or points.}

\item{...}{Other arguments to pass to \code{plot} function if \code{new.plot} is \code{TRUE}.}
}
\description{
Create a fan plot from a matrix of distribution parameters
}
\examples{
data <- matrix(c(0, 1, 1, 4), ncol = 2)
rownames(data) <- c("A", "B")
fan.plot(data)
fan.plot(data, dist = "log-normal")
fan.plot(data, gradient = TRUE)
 fan.plot(data, gradient = TRUE)
fan.plot(data, gradient = FALSE, new.plot = FALSE,
        boundColor = adjustcolor("red", alpha.f = 0.2),
        midColor = NA)

}
