% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{get.options.roc}
\alias{get.options.roc}
\title{Get Options for ROC and AUC Calculations}
\usage{
get.options.roc(
  lowerThreshold = 0,
  upperThreshold = 1,
  epsilon = 1e-12,
  pessimistic = FALSE,
  costs = NULL,
  costMatrix = NULL
)
}
\arguments{
\item{lowerThreshold}{A number representing the lower bound for calculating partial AUC.}

\item{upperThreshold}{A number representing the upper bound for calculating partial AUC.}

\item{epsilon}{A small number used to ignore small floating point differences when comparing scores.}

\item{pessimistic}{If \code{TRUE}, sequences of equally scored instances are treated differently and a pessimistic metric is calculated (see Fawcett (2006) An introduction to ROC analysis, fig. 6).}

\item{costs}{The cost of each observation. If \code{NULL}, the cost of all observations will be 1.}

\item{costMatrix}{A \code{2x2} cost matrix in which: (1,1) is the cost of TN,
(2,2) is the cost of TP, (1,2) is the cost of FP and (2,1) is the cost of FN. The first
column is multiplied by the corresponding value in the costs vector (see
Fawcett (2006), ROC graphs with instance-varying costs).}
}
\value{
A list with the given options.
}
\description{
Use this function to get the required options for \link{search.bin}, \link{estim.bin}, or \link{s.roc} functions.
}
\details{
See details of \link{s.roc} function.
}
\examples{
# See 's.roc' function.


}
\seealso{
\link{search.bin}, \link{estim.bin}, \link{s.roc}
}
