% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{summary.ldtsearch}
\alias{summary.ldtsearch}
\title{Summarize an \code{ldtsearch} object}
\usage{
\method{summary}{ldtsearch}(
  object,
  y,
  x = NULL,
  addModelBests = TRUE,
  addModelAll = FALSE,
  addItem1Bests = FALSE,
  printMsg = FALSE,
  w = NULL,
  newX = NULL,
  test = FALSE,
  ...
)
}
\arguments{
\item{object}{\code{ldtsearch} object}

\item{y}{dependent variables data (Data is not saved in \code{object})}

\item{x}{exogenous variables data (Data is not saved in \code{object})}

\item{addModelBests}{if \code{TRUE} and 'model$bests' exists
(see \code{[GetSearchItems()]}), it estimates them.}

\item{addModelAll}{if \code{TRUE} and 'all' exists
(see \code{[GetSearchItems()]}), it estimates them.}

\item{addItem1Bests}{if \code{TRUE} and 'item1' exists
(see \code{[GetSearchItems()]}), it estimates them.}

\item{printMsg}{if \code{TRUE} details are printed.}

\item{w}{weight of observations (if available, e.g., in discrete choice estimation.
Data is not saved in \code{object})}

\item{newX}{new exogenous data (if available, e.g., in varma estimation.
Data is not saved in \code{object})}

\item{test}{If \code{TRUE}, it helps you make sure everything is working. Please report errors.}

\item{...}{additional arguments}
}
\value{
a list with estimated models along with other kind of information.
Its structure is similar to the given \code{ldtsearch} object.
}
\description{
Summarize an \code{ldtsearch} object
}
