% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{LongrunGrowth}
\alias{LongrunGrowth}
\title{Calculate Long-run Growth}
\usage{
LongrunGrowth(
  data,
  trimStart = 0,
  trimEnd = 0,
  cont = FALSE,
  skipZero = TRUE,
  isPercentage = FALSE,
  ...
)
}
\arguments{
\item{data}{(integer vector) data}

\item{trimStart}{(integer) if the number of leading NAs is larger
than this number, it returns NA. Otherwise, it finds the first
number and continue the calculations.}

\item{trimEnd}{(integer) if the number of trailing NAs is larger
than this number, it returns NA. Otherwise, it finds the first number
and continue the calculations.}

\item{cont}{(logical) if \code{TRUE} it will use the continuous formula.}

\item{skipZero}{(logical) if \code{TRUE} leading and trailing
zeros are skipped.}

\item{isPercentage}{(logical) if the unit of measurement in \code{data}
is percentage (e.g., growth rate) use \code{TRUE}. Long-run growth rate
is calculated by arithmetic mean for continuous case, and geometric mean
otherwise. If missing data exists, it returns NA.}

\item{...}{additional arguments}
}
\value{
the growth rate (percentage)
}
\description{
Calculate Long-run Growth
}
\examples{
y <- c(NA, 0, c(60, 70, 80, 90), 0, NA, NA)
g <- LongrunGrowth(y, 2, 3, skipZero = TRUE, isPercentage = TRUE, cont = TRUE)

}
