% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_data_mt.R
\name{import_data_mt}
\alias{import_data_mt}
\title{Import Market Type related Data to R from the Sandbox}
\usage{
import_data_mt(path_terminal, trade_log_file, system_number, demo_mode = FALSE)
}
\arguments{
\item{path_terminal}{- path to the sandbox}

\item{trade_log_file}{- direct path to the log file (used for demo purposes)}

\item{system_number}{- magic number id of the trading system}

\item{demo_mode}{- when true, uses sample datafile stored in the package}
}
\value{
function returns the data frame with 3 columns including market type code
}
\description{
Function imports file from the MetaTrader sandbox. Function performs necessary cleansing of the data column types
}
\examples{

library(dplyr)
library(readr)
library(lazytrade)
import_data_mt(trade_log_file = system.file("extdata", "MarketTypeLog9139106.csv",
                                            package = "lazytrade"),
               demo_mode = TRUE)



}
\author{
(C) 2019 Vladimir Zhbanko
}
