% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_model.R
\name{test_model}
\alias{test_model}
\title{Test model using independent price data.}
\usage{
test_model(test_dataset, predictor_dataset, test_type)
}
\arguments{
\item{test_dataset}{- Dataset containing the column 'LABEL' which will correspond to the real outcome of Asset price change. This
column will be used to verify the trading strategy}

\item{predictor_dataset}{- Dataset containing the column 'predict'. This column is corresponding to the predicted outcome of Asset
change. This column will be used to verify strategy outcomes}

\item{test_type}{can be either "regression" or "classification" used to distinguish which type of model is being used}
}
\value{
Function will return a data frame with several quality score metrics for the best model.
        In case quality score is positive or more than 1 the model would likely be working good.
        In case the score will be negative then the model is not predicting good.
        Internal logic will test several predictor thresholds and will indicate the best one
}
\description{
Goal of the function is to verify how good predicted results are.
}
\details{
This function should work to backtest any possible dataset lenght. It could be that we will need to use it for testing
1 week or 1 month. It should also work for both Regression and Classification models. Note: strategy outcomes assumes trading on
all 28 major forex pairs
}
\examples{

library(tidyverse)
data(result_prev)
data(test_data_pattern)

## evaluate hypothetical results of trading using the model
test_model(test_dataset = test_data_pattern,
           predictor_dataset = result_prev,
           test_type = "regression")



}
