% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-lazyarray.R
\name{LazyArray}
\alias{LazyArray}
\title{Internal Class definition for \code{LazyArray}}
\description{
Internal class definition of lazy array objects
}
\author{
Zhengjia Wang
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{meta_name}}{file name to store meta information}

\item{\code{min_version}}{minimal version supported, for backward compatibility concerns}

\item{\code{version}}{current version of lazy data instance}

\item{\code{dim}}{dimension of the data}

\item{\code{dimnames}}{dimension names of the data}

\item{\code{ndim}}{length of dimensions}

\item{\code{can_write}}{is array read-only or writable}

\item{\code{storage_path}}{directory where the data is stored at}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-print}{\code{LazyArray$print()}}
\item \href{#method-new}{\code{LazyArray$new()}}
\item \href{#method-flag_auto_clean}{\code{LazyArray$flag_auto_clean()}}
\item \href{#method-finalize}{\code{LazyArray$finalize()}}
\item \href{#method-remove_data}{\code{LazyArray$remove_data()}}
\item \href{#method-make_writable}{\code{LazyArray$make_writable()}}
\item \href{#method-make_readonly}{\code{LazyArray$make_readonly()}}
\item \href{#method-set_dim}{\code{LazyArray$set_dim()}}
\item \href{#method-get_file_format}{\code{LazyArray$get_file_format()}}
\item \href{#method-get_storage_format}{\code{LazyArray$get_storage_format()}}
\item \href{#method-is_multi_part}{\code{LazyArray$is_multi_part()}}
\item \href{#method-partition_dim}{\code{LazyArray$partition_dim()}}
\item \href{#method-get_partition_fpath}{\code{LazyArray$get_partition_fpath()}}
\item \href{#method-@set_data}{\code{LazyArray$@set_data()}}
\item \href{#method-set_compress_level}{\code{LazyArray$set_compress_level()}}
\item \href{#method-get_compress_level}{\code{LazyArray$get_compress_level()}}
\item \href{#method-@get_data}{\code{LazyArray$@get_data()}}
\item \href{#method-@sample_data}{\code{LazyArray$@sample_data()}}
\item \href{#method-clone}{\code{LazyArray$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Override print method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LazyArray$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
self instance
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LazyArray$new(path, read_only = TRUE, meta_name = "lazyarray.meta")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{directory to store data into}

\item{\code{read_only}}{whether modification is allowed}

\item{\code{meta_name}}{meta file to store the data into}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-flag_auto_clean"></a>}}
\if{latex}{\out{\hypertarget{method-flag_auto_clean}{}}}
\subsection{Method \code{flag_auto_clean()}}{
Set auto clean flag
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LazyArray$flag_auto_clean(auto)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{auto}}{logical whether the data on hard disk will be automatically cleaned}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-finalize}{}}}
\subsection{Method \code{finalize()}}{
Override finalize method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LazyArray$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-remove_data"></a>}}
\if{latex}{\out{\hypertarget{method-remove_data}{}}}
\subsection{Method \code{remove_data()}}{
Remove data on hard disk
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LazyArray$remove_data(force = FALSE, warn = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{force}}{whether to force remove the data}

\item{\code{warn}}{whether to show warning if not fully cleaned}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-make_writable"></a>}}
\if{latex}{\out{\hypertarget{method-make_writable}{}}}
\subsection{Method \code{make_writable()}}{
Make instance writable
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LazyArray$make_writable()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-make_readonly"></a>}}
\if{latex}{\out{\hypertarget{method-make_readonly}{}}}
\subsection{Method \code{make_readonly()}}{
Make instance read-only
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LazyArray$make_readonly()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_dim"></a>}}
\if{latex}{\out{\hypertarget{method-set_dim}{}}}
\subsection{Method \code{set_dim()}}{
Set \code{\link[base]{dim}} and \code{\link[base]{dimnames}} of the array
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LazyArray$set_dim(dim, dimnames)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dim}}{integer vector of the array dimension; see \code{\link[base]{dim}}}

\item{\code{dimnames}}{named list of dimension names; see \code{\link[base]{dimnames}}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_file_format"></a>}}
\if{latex}{\out{\hypertarget{method-get_file_format}{}}}
\subsection{Method \code{get_file_format()}}{
Partition format, currently only \code{'fst'} is supported
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LazyArray$get_file_format()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_storage_format"></a>}}
\if{latex}{\out{\hypertarget{method-get_storage_format}{}}}
\subsection{Method \code{get_storage_format()}}{
Data storage format, expected to be one of the 
followings: 'double', 'integer', 'character', or 'complex'
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LazyArray$get_storage_format()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_multi_part"></a>}}
\if{latex}{\out{\hypertarget{method-is_multi_part}{}}}
\subsection{Method \code{is_multi_part()}}{
Whether partitioned based on the last dimension
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LazyArray$is_multi_part()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-partition_dim"></a>}}
\if{latex}{\out{\hypertarget{method-partition_dim}{}}}
\subsection{Method \code{partition_dim()}}{
Returns dimension of each partition
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LazyArray$partition_dim()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_partition_fpath"></a>}}
\if{latex}{\out{\hypertarget{method-get_partition_fpath}{}}}
\subsection{Method \code{get_partition_fpath()}}{
Get partition path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LazyArray$get_partition_fpath(part, full_path = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{part}}{integer representing the partition}

\item{\code{full_path}}{whether return the full system path}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Character file name or full path
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-@set_data"></a>}}
\if{latex}{\out{\hypertarget{method-@set_data}{}}}
\subsection{Method \code{@set_data()}}{
Internal method to set data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LazyArray$@set_data(value, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{vector of data to be set}

\item{\code{...}}{index set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_compress_level"></a>}}
\if{latex}{\out{\hypertarget{method-set_compress_level}{}}}
\subsection{Method \code{set_compress_level()}}{
Set compression level
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LazyArray$set_compress_level(level)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{level}}{from 0 to 100. 0 means no compression, 100 means max compression}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_compress_level"></a>}}
\if{latex}{\out{\hypertarget{method-get_compress_level}{}}}
\subsection{Method \code{get_compress_level()}}{
Get compression level
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LazyArray$get_compress_level()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-@get_data"></a>}}
\if{latex}{\out{\hypertarget{method-@get_data}{}}}
\subsection{Method \code{@get_data()}}{
Internal method to read data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LazyArray$@get_data(..., drop = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{index set}

\item{\code{drop}}{whether to drop dimension after subset, default is true}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-@sample_data"></a>}}
\if{latex}{\out{\hypertarget{method-@sample_data}{}}}
\subsection{Method \code{@sample_data()}}{
Internal method to obtain a sample data to be used to determine storage mode
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LazyArray$@sample_data()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LazyArray$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
