% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/square_grid.R
\name{lawn_square_grid}
\alias{lawn_square_grid}
\title{Create a SquareGrid}
\usage{
lawn_square_grid(extent, cellSide, units = "kilometers", mask = NULL)
}
\arguments{
\item{extent}{(numeric) Extent in \verb{[minX, minY, maxX, maxY]} order.}

\item{cellSide}{(integer) dimension of each cell.}

\item{units}{(character) Units to use for cellSide, one of 'miles' or
'kilometers'.}

\item{mask}{(logical) if passed a Polygon or MultiPolygon, the grid
Points will be created only inside it}
}
\value{
\link{data-FeatureCollection} grid of polygons.
}
\description{
Takes a bounding box and a cell depth and returns a set of square
\link{data-Polygon}'s in a grid.
}
\examples{
\dontrun{
lawn_square_grid(c(-95, 30 ,-85, 40), 30, 'miles')
lawn_square_grid(c(-95, 30 ,-85, 40), 10, 'miles')
lawn_square_grid(c(-95, 30 ,-85, 40), 3, 'miles')
}
}
\seealso{
Other interpolation: 
\code{\link{lawn_hex_grid}()},
\code{\link{lawn_isolines}()},
\code{\link{lawn_planepoint}()},
\code{\link{lawn_point_grid}()},
\code{\link{lawn_tin}()},
\code{\link{lawn_triangle_grid}()}
}
\concept{interpolation}
