% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{lawn_filter}
\alias{lawn_filter}
\title{Filter a FeatureCollection by a given property and value}
\usage{
lawn_filter(features, key, value, lint = FALSE)
}
\arguments{
\item{features}{A \link{data-FeatureCollection}}

\item{key}{(character) The property on which to filter.}

\item{value}{(character) The value of that property on which to filter.}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
S filtered \link{data-FeatureCollection} with only
features that match input key and value.
}
\description{
Filter a FeatureCollection by a given property and value
}
\examples{
cat(lawn_data$filter_features)
lawn_filter(features = lawn_data$filter_features, key = 'species',
  value = 'oak')
lawn_filter(lawn_data$filter_features, 'species', 'maple')
lawn_filter(lawn_data$filter_features, 'species', 'redwood')
}
\seealso{
Other data functions: 
\code{\link{lawn_featurecollection}()},
\code{\link{lawn_feature}()},
\code{\link{lawn_geometrycollection}()},
\code{\link{lawn_linestring}()},
\code{\link{lawn_multilinestring}()},
\code{\link{lawn_multipoint}()},
\code{\link{lawn_multipolygon}()},
\code{\link{lawn_point}()},
\code{\link{lawn_polygon}()},
\code{\link{lawn_random}()},
\code{\link{lawn_remove}()},
\code{\link{lawn_sample}()}
}
\concept{data functions}
