% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jenks.R
\name{lawn_jenks}
\alias{lawn_jenks}
\title{Get Jenks breaks}
\usage{
lawn_jenks(input, field, numberOfBreaks, lint = FALSE)
}
\arguments{
\item{input}{Set of \code{\link{data-Feature}}'s}

\item{field}{the property in input on which to calculate Jenks natural breaks}

\item{numberOfBreaks}{Number of classes in which to group the data}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing time
as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good geojson
objects. Default: \code{FALSE}}
}
\value{
An array of the break values (numeric)
}
\description{
Takes a set of \code{\link{data-Feature}}'s and returns an array of the Jenks
Natural breaks for a given property
}
\examples{
lawn_jenks(lawn_data$points_average, 'population', 0)
lawn_jenks(lawn_data$points_average, 'population', 1)
lawn_jenks(lawn_data$points_average, 'population', 2)
lawn_jenks(lawn_data$points_average, 'population', 3)
lawn_jenks(lawn_data$points_average, 'population', 4)
}
\references{
Jenks Natural breaks
\url{http://en.wikipedia.org/wiki/Jenks_natural_breaks_optimization}
}
\seealso{
Other classification: \code{\link{lawn_nearest}},
  \code{\link{lawn_quantile}}, \code{\link{lawn_reclass}}
}

