% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polygon.R
\name{lawn_polygon}
\alias{lawn_polygon}
\title{Create a polygon}
\usage{
lawn_polygon(rings, properties = NULL)
}
\arguments{
\item{rings}{A list of LinearRings, or in json}

\item{properties}{A list of properties}
}
\value{
a \code{\link{data-Polygon}} feature
}
\description{
Create a polygon
}
\examples{
rings <- list(list(
   c(-2.275543, 53.464547),
   c(-2.275543, 53.489271),
   c(-2.215118, 53.489271),
   c(-2.215118, 53.464547),
   c(-2.275543, 53.464547)
))
lawn_polygon(rings, properties = list(name = 'poly1', population = 400))

# Make a FeatureCollection
lawn_featurecollection(lawn_polygon(rings))

}
\seealso{
Other data functions: \code{\link{lawn_featurecollection}},
  \code{\link{lawn_filter}}, \code{\link{lawn_linestring}},
  \code{\link{lawn_point}}, \code{\link{lawn_random}},
  \code{\link{lawn_remove}}, \code{\link{lawn_sample}}
}

