% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefByType.R
\name{coefByType}
\alias{coefByType}
\alias{coefCov}
\alias{coefCov.lvm}
\alias{coefCov.lvmfit}
\alias{coefCov.multigroup}
\alias{coefExtra}
\alias{coefExtra.lvm}
\alias{coefExtra.lvmfit}
\alias{coefExtra.multigroup}
\alias{coefIndexModel}
\alias{coefIndexModel.lvm}
\alias{coefIndexModel.lvmfit}
\alias{coefIndexModel.multigroup}
\alias{coefIndexModel.multigroupfit}
\alias{coefIntercept}
\alias{coefIntercept.lvm}
\alias{coefIntercept.lvmfit}
\alias{coefIntercept.multigroup}
\alias{coefRef}
\alias{coefRef.lvmfit}
\alias{coefReg}
\alias{coefReg.lvm}
\alias{coefReg.lvmfit}
\alias{coefReg.multigroup}
\alias{coefVar}
\alias{coefVar.lvm}
\alias{coefVar.lvmfit}
\alias{coefVar.multigroup}
\title{Extract the Coefficient by Type}
\usage{
coefCov(object, ...)

\method{coefCov}{lvm}(object, value = FALSE, keep.var = FALSE, ...)

\method{coefCov}{lvmfit}(object, value = FALSE, keep.var = FALSE, ...)

\method{coefCov}{multigroup}(object, value = FALSE, keep.var = FALSE, ...)

coefExtra(object, ...)

\method{coefExtra}{lvm}(object, value = FALSE, ...)

\method{coefExtra}{lvmfit}(object, value = FALSE, ...)

\method{coefExtra}{multigroup}(object, value = FALSE, ...)

coefIndexModel(object, ...)

\method{coefIndexModel}{lvm}(object, ...)

\method{coefIndexModel}{lvmfit}(object, ...)

\method{coefIndexModel}{multigroup}(object, ...)

\method{coefIndexModel}{multigroupfit}(object, ...)

coefIntercept(object, ...)

\method{coefIntercept}{lvm}(object, value = FALSE, ...)

\method{coefIntercept}{lvmfit}(object, value = FALSE, ...)

\method{coefIntercept}{multigroup}(object, value = FALSE, ...)

coefRef(object, ...)

\method{coefRef}{lvmfit}(object, value = FALSE, ...)

coefReg(object, ...)

\method{coefReg}{lvm}(object, value = FALSE, ...)

\method{coefReg}{lvmfit}(object, value = FALSE, ...)

\method{coefReg}{multigroup}(object, value = FALSE, ...)

coefVar(object, ...)

\method{coefVar}{lvm}(object, value = FALSE, ...)

\method{coefVar}{lvmfit}(object, value = FALSE, ...)

\method{coefVar}{multigroup}(object, value = FALSE, ...)
}
\arguments{
\item{object}{a lvm model or a fitted lvm model}

\item{...}{arguments to be passed to \code{}}

\item{value}{should the name of the coefficient be returned? Else return the coefficients}

\item{keep.var}{should the variance coefficients be returned?}
}
\value{
A vector containing the names of the positions of the coefficients.
}
\description{
Extract specific types of coefficient from a \code{lvm} object:
covariance coefficient(s) (\code{coefCov}),
extra parameter(s) (\code{coefExtra}),
position in the list of models for each coefficient (\code{coefIndexModel}),
intercept coefficient(s) (\code{coefIntercept}),
coefficient(s) that are used as reference (\code{coefRef}),
regression coefficient(s) (\code{coefReg}),
variance coefficient(s) (\code{coefVar}).
}
\examples{
#### regression ####
m <- lvm(Y~X1+X2)
e <- estimate(m, lava::sim(m, 1e2))

coefCov(m)
coefCov(m, value = TRUE)

coefCov(m, keep.var = TRUE)
coefCov(m, value = TRUE, keep.var = TRUE)

coefIndexModel(m)
coefIndexModel(e)

coefIntercept(m)
coefIntercept(m, value = TRUE)

coefReg(m)
coefReg(m, value = TRUE)

#### LVM ####
m <- lvm()
regression(m) <- c(y1,y2,y3)~u
regression(m) <- u~x1+x2
latent(m) <- ~u
covariance(m) <- y1~y2

m.Sim <- m
categorical(m.Sim, labels = c("a","b","c")) <- ~x2
e <- estimate(m, lava::sim(m.Sim, 1e2))

coefCov(m)
coefCov(m, value = TRUE) 

coefCov(m, keep.var = TRUE)
coefCov(m, value = TRUE, keep.var = TRUE)

coefExtra(m)

coefIndexModel(m)
coefIndexModel(e)

## additional categorical variable 
categorical(m, labels = as.character(1:3)) <- "X1"

coefExtra(m)
coefExtra(m, value = TRUE)

## additional categorical variable
categorical(m, labels = as.character(1:3)) <- "x1"

coefIntercept(m)
coefIntercept(m, value = TRUE)
coefIntercept(e)

coefReg(e, value = TRUE)

#### multigroup ####
m <- lvm(Y~X1+X2)
eG <- estimate(list(m,m), list(lava::sim(m, 1e2), lava::sim(m, 1e2)))

coefIndexModel(eG)

}
\concept{
extractor
}
