% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sCorrect.R
\name{sCorrect}
\alias{sCorrect}
\alias{sCorrect.lm}
\alias{sCorrect.gls}
\alias{sCorrect.lme}
\alias{sCorrect.lvmfit}
\alias{sCorrect.lvmfit2}
\alias{sCorrect<-}
\alias{sCorrect<-.lm}
\alias{sCorrect<-.gls}
\alias{sCorrect<-.lme}
\alias{sCorrect<-.lvmfit}
\alias{sCorrect<-.lvmfit2}
\title{Compute the Derivative of the Information Matrix}
\usage{
sCorrect(object, ...)

\method{sCorrect}{lm}(object, bias.correct = FALSE, return.score = FALSE,
  ...)

\method{sCorrect}{gls}(object, cluster, vcov.param = NULL,
  bias.correct = FALSE, numeric.derivative = FALSE, return.score = FALSE,
  ...)

\method{sCorrect}{lme}(object, cluster, vcov.param = NULL,
  bias.correct = FALSE, numeric.derivative = FALSE, return.score = FALSE,
  ...)

\method{sCorrect}{lvmfit}(object, vcov.param = NULL, bias.correct = TRUE,
  numeric.derivative = FALSE, return.score = FALSE, ...)

\method{sCorrect}{lvmfit2}(object, ...)

sCorrect(x, ...) <- value

\method{sCorrect}{lm}(x, ...) <- value

\method{sCorrect}{gls}(x, ...) <- value

\method{sCorrect}{lme}(x, ...) <- value

\method{sCorrect}{lvmfit}(x, ...) <- value

\method{sCorrect}{lvmfit2}(x, ...) <- value
}
\arguments{
\item{object, x}{a \code{gls}, \code{lme}, or \code{lvm} object.}

\item{...}{[internal] only used by the generic method or by the <- methods.}

\item{bias.correct, value}{[logical] should the standard errors of the coefficients be corrected for small sample bias?}

\item{return.score}{[internal] export the score.}

\item{cluster}{[vector] the grouping variable relative to which the observations are iid.
Only required for \code{gls} models with no correlation argument.}

\item{vcov.param}{[matrix] the variance-covariance matrix of the estimates.}

\item{numeric.derivative}{[logical] should a numerical derivative be used to compute the first derivative of the information matrix?
Otherwise an analytic formula is used.}
}
\description{
Compute the derivative of the information matrix.
}
\concept{
small sample inference

derivative of the score equation
}
