% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var2dummy.R
\name{var2dummy}
\alias{var2dummy}
\alias{var2dummy.list}
\alias{var2dummy.lvm}
\title{Convert Variable Names to Dummy Variables Names.}
\usage{
var2dummy(x, ...)

\method{var2dummy}{list}(x, var, rm.first.factor = TRUE, ...)

\method{var2dummy}{lvm}(x, data = NULL, ...)
}
\arguments{
\item{x}{a latent variable model.}

\item{...}{additional arguments to be passed to lower levels functions.}

\item{var}{the variable to be transformed.}

\item{rm.first.factor}{should the first level of each categorical variable be ignored?}

\item{data}{dataset according to which the model should be updated.}
}
\description{
When dealing with categorical variables, the \code{estimate} function convert the categorical variables into dummy variables.
This function convert a set of variable names to their corresponding name in the model with dummy variables
}
\examples{
library(lava)

m <- lvm()
regression(m) <- c(y1,y2,y3)~u
regression(m) <- u ~ X1+X2
var2dummy(m, var = c("X1","X2"))
categorical(m,labels=c("M","F","MF")) <- ~X1
var2dummy(m, var = c("X1","X2"))
categorical(m,labels=c("1","2","3")) <- ~X2
var2dummy(m, var = c("X1","X2"))
}
