% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addQuantVar.R
\name{addQuantVar}
\alias{addQuantVar}
\title{Input data for Nonparametric Regression smoothing.}
\usage{
addQuantVar(formLatticeOutput, Z, locations)
}
\arguments{
\item{formLatticeOutput}{An object from the functions formLattice or
editLattice.}

\item{Z}{A vector of response variable values.}

\item{locations}{A two-column matrix or data frame of data locations.

#' @references Ronald P. Barry, Julie McIntyre.  Estimating animal densities and home
range in regions with irregular boundaries and holes:  A lattice-based
alternative to the kernel density estimator.
Ecological Modelling 222 (2011)  1666-1672.}
}
\description{
This function takes a \code{formLatticeOutput} object, which encodes a region
possibly with and irregular boundary and holes.  This and a matrix of
locations where a response variable has been measured, and a vector of
the responses, is used to create an initial distribution for use in the
non-parametric regression function \code{createNparReg}.  If, instead, you
have a point process and wish to produce a density estimate, you should use
the function \code{addObservations}.
}
\references{
Julie McIntyre, Ronald P. Barry (2018)  A Lattice-Based 
Smoother for Regions with Irregular Boundaries and Holes.  
Journal of Computational and Graphical Statistics.  In Press.
}
