\name{editLattice}
\alias{editLattice}
\title{
Add or remove links in the lattice
}
\description{
\code{editLattice} is an interactive editor based on the function edit.nb
from the package spdep.  A \code{formLatticeOutput} object includes an automatically 
generated neighborhood structure.  Occasionally this will either leave 
two nodes disconnected that should be connected or vice versa.  
\code{editLattice} allows the user to directly edit the plot of the 
lattice using mouseclicks to add or remove neighbor links between nodes.
}
\usage{
editLattice(formLatticeOutput)
}
\arguments{
  \item{formLatticeOutput}{
a formLatticeOutput object, returned by \code{formLattice} or \code{editLattice}.
}
}
\value{
a formLatticeOutput object, which contains
\item{EWlocs }{EW coordinates for use in contour}
\item{NSlocs }{NS coordinates for use in contour}
\item{nodes }{matrix of node locations}
\item{poly }{matrix of vertices of the boundary polygon}
\item{latt }{lattice object as generated by dnearneigh of package spdep}
}
%\references{
%Ronald P. Barry, Julie McIntyre.  Estimation animal densities and home
%range in regions with irregular boundaries and holes:  A lattice-based
%alternative to the kernel density estimator.
%Ecological Modelling 222 (2011)  1666-1672.
%}
\author{
Ronald P. Barry
}


\seealso{
formLattice
}
\examples{
  \dontrun{
plot.new()
data(polygon1)
nodeFillingOutput = nodeFilling(poly=polygon1,node.spacing=0.03)
plot(nodeFillingOutput)
formLatticeOutput = formLattice(nodeFillingOutput)
plot(formLatticeOutput)
formLatticeOutput = editLattice(formLatticeOutput)
#
#  Paste the code above into R, then do the editing before
#  pasting the code below into R.
#
Pointdata = csr(polygon1,20)
densityOut = createDensity(formLatticeOutput,PointPattern=Pointdata, 
  k=150,intensity=FALSE, sparse = TRUE)
plot(densityOut)
}
}
%\keyword{ ~kwd1 }
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
