% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodFlexmixGBTM.R
\name{lcMethodFlexmixGBTM}
\alias{lcMethodFlexmixGBTM}
\title{Group-based trajectory modeling using flexmix}
\usage{
lcMethodFlexmixGBTM(
  formula,
  formula.mb = ~1,
  time = getOption("latrend.time"),
  id = getOption("latrend.id"),
  nClusters = 2,
  ...
)
}
\arguments{
\item{formula}{A \code{formula} specifying the model.}

\item{formula.mb}{A \code{formula} specifying the class membership model. By default, an intercept-only model is used.}

\item{time}{The name of the time variable.}

\item{id}{The name of the trajectory identifier variable.}

\item{nClusters}{The number of clusters to estimate.}

\item{...}{Arguments passed to \link[flexmix:flexmix]{flexmix::flexmix} or \link[flexmix:FLXglm]{flexmix::FLXMRglm}.
The following arguments are ignored: data, k, trace.}
}
\description{
Fits a GBTM based on the \link[flexmix:FLXglm]{flexmix::FLXMRglm} driver.
}
\examples{
data(latrendData)
if (require("flexmix")) {
  method <- lcMethodFlexmixGBTM(Y ~ Time, id = "Id", time = "Time", nClusters = 3)
  model <- latrend(method, latrendData)
}
}
\references{
\insertRef{gruen2008flexmix}{latrend}
}
\seealso{
Other lcMethod package interfaces: 
\code{\link{lcMethodFlexmix}}
}
\concept{lcMethod package interfaces}
