% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodAKMedoids.R
\name{lcMethodAkmedoids}
\alias{lcMethodAkmedoids}
\title{Specify AKMedoids method}
\usage{
lcMethodAkmedoids(
  response,
  time = getOption("latrend.time"),
  id = getOption("latrend.id"),
  nClusters = 3,
  clusterCenter = median,
  crit = "Calinski_Harabasz",
  ...
)
}
\arguments{
\item{response}{The name of the response variable.}

\item{time}{The name of the time variable.}

\item{id}{The name of the trajectory identification variable.}

\item{nClusters}{The number of clusters to estimate.}

\item{clusterCenter}{A function for computing the cluster center representation.}

\item{crit}{Criterion to apply for internal model selection. Not applicable.}

\item{...}{Arguments passed to \code{akmedoids::akclustr}.
The following external arguments are ignored: traj, id_field, k}
}
\description{
Specify AKMedoids method
}
\examples{
data(latrendData)
if (rlang::is_installed("akmedoids")) {
  method <- lcMethodAkmedoids(response = "Y", time = "Time", id = "Id", nClusters = 3)
  model <- latrend(method, data = latrendData)
}
}
\references{
\insertRef{adepeju2020akmedoids}{latrend}
}
\seealso{
Other lcMethod implementations: 
\code{\link{getArgumentDefaults}()},
\code{\link{getArgumentExclusions}()},
\code{\link{lcMethod-class}},
\code{\link{lcMethodCrimCV}},
\code{\link{lcMethodDtwclust}},
\code{\link{lcMethodFeature}},
\code{\link{lcMethodFunFEM}},
\code{\link{lcMethodFunction}},
\code{\link{lcMethodGCKM}},
\code{\link{lcMethodKML}},
\code{\link{lcMethodLMKM}},
\code{\link{lcMethodLcmmGBTM}},
\code{\link{lcMethodLcmmGMM}},
\code{\link{lcMethodMclustLLPA}},
\code{\link{lcMethodMixAK_GLMM}},
\code{\link{lcMethodMixtoolsGMM}},
\code{\link{lcMethodMixtoolsNPRM}},
\code{\link{lcMethodRandom}},
\code{\link{lcMethodStratify}}
}
\concept{lcMethod implementations}
