% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{print.lcModels}
\alias{print.lcModels}
\title{Print lcModels list concisely}
\usage{
\method{print}{lcModels}(
  x,
  ...,
  summary = FALSE,
  excludeShared = !getOption("latrend.printSharedModelArgs")
)
}
\arguments{
\item{x}{The \code{lcModels} object.}

\item{...}{Not used.}

\item{summary}{Whether to print the complete summary per model. This may be slow for long lists!}

\item{excludeShared}{Whether to exclude model arguments which are identical across all models.}
}
\description{
Print lcModels list concisely
}
\section{Functionality}{

\itemize{
\item \link[=print.lcModels]{Print} an argument summary for each of the models.
\item \link[=as.data.frame.lcModels]{Convert} to a \code{data.frame} of method arguments.
\item \link[=subset.lcModels]{Subset} the list.
\item Compute an \link[=metric]{internal metric} or \link[=externalMetric]{external metric}.
\item Obtain the best model according to \link[=min.lcModels]{minimizing} or \link[=max.lcModels]{maximizing} a \link[=latrend-metrics]{metric}.
\item Obtain the summed \link[=estimationTime]{estimation time}.
\item \link[=plotMetric]{Plot a metric} across a variable.
\item \link[=plotClusterTrajectories]{Plot the cluster trajectories}.
}
}

\seealso{
Other lcModels functions: 
\code{\link{as.lcModels}()},
\code{\link{lcModels-class}},
\code{\link{lcModels}},
\code{\link{max.lcModels}()},
\code{\link{min.lcModels}()},
\code{\link{plotMetric}()},
\code{\link{subset.lcModels}()}
}
\concept{lcModels functions}
