% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{plot-lcModel-method}
\alias{plot-lcModel-method}
\alias{plot,lcModel,ANY-method}
\alias{plot,lcModel-method}
\title{Plot a lcModel}
\usage{
\S4method{plot}{lcModel}(x, y, ...)
}
\arguments{
\item{x}{The \code{lcModel} object.}

\item{y}{Not used.}

\item{...}{
  Arguments passed on to \code{\link[=plotClusterTrajectories]{plotClusterTrajectories}}
  \describe{
    \item{\code{object}}{The (cluster) trajectory data.}
  }}
}
\value{
A \code{ggplot} object.
}
\description{
Plot a \code{lcModel} object. By default, this plots the cluster trajectories of the model, along with the training data.
}
\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
model <- latrend(method, latrendData, nClusters = 3)

if (require("ggplot2")) {
  plot(model)
}
}
\seealso{
\link{plotClusterTrajectories} \link{plotFittedTrajectories} \link{plotTrajectories} \link[ggplot2:ggplot]{ggplot2::ggplot}
}
