% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latrend.R
\name{latrendBoot}
\alias{latrendBoot}
\title{Cluster longitudinal data using bootstrapping}
\usage{
latrendBoot(
  method,
  data,
  samples = 50,
  seed = NULL,
  parallel = FALSE,
  errorHandling = "stop",
  envir = NULL,
  verbose = getOption("latrend.verbose")
)
}
\arguments{
\item{method}{The \code{lcMethod} object specifying the longitudinal cluster method to apply.}

\item{data}{A \code{data.frame}.}

\item{samples}{The number of bootstrap samples to evaluate.}

\item{seed}{The seed to use. Optional.}

\item{parallel}{Whether to enable parallel evaluation. See \link{latrend-parallel}.}

\item{errorHandling}{Whether to \code{"stop"} on an error, or to \verb{"remove'} evaluations that raised an error.}

\item{envir}{The \code{environment} in which to evaluate the method arguments. Note that this only applies to \code{data} when \code{data} is a \code{call}.}

\item{verbose}{The level of verbosity. Either an object of class \code{Verbose} (see \link[R.utils:Verbose]{R.utils::Verbose} for details),
a \code{logical} indicating whether to show basic computation information,
a \code{numeric} indicating the verbosity level (see \link{Verbose}),
or one of \code{c('info', 'fine', 'finest')}.}
}
\value{
A \code{lcModels} object of length \code{samples}.
}
\description{
Performs bootstrapping, generating samples from the given data at the id level, fitting a lcModel to each sample.
}
\examples{
data(latrendData)
method <- lcMethodKML("Y", id = "Id", time = "Time")
model <- latrendBoot(method, latrendData, samples = 10)
}
\seealso{
Other longitudinal cluster fit functions: 
\code{\link{latrendBatch}()},
\code{\link{latrendCV}()},
\code{\link{latrendRep}()},
\code{\link{latrend}()}

Other validation methods: 
\code{\link{createTestDataFolds}()},
\code{\link{createTestDataFold}()},
\code{\link{createTrainDataFolds}()},
\code{\link{latrendCV}()},
\code{\link{lcModel-data-filters}}
}
\concept{longitudinal cluster fit functions}
\concept{validation methods}
