% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{as.data.frame.lcMethod}
\alias{as.data.frame.lcMethod}
\title{Convert lcMethod arguments to a list of atomic types}
\usage{
\method{as.data.frame}{lcMethod}(x, ..., eval = FALSE, nullValue = NA, envir = NULL)
}
\arguments{
\item{x}{\code{lcMethod} to be coerced to a \code{character} \code{vector}.}

\item{...}{Additional arguments.}

\item{eval}{Whether to evaluate the arguments in order to replace expression if the resulting value is of a class specified in \code{evalClasses}.}

\item{nullValue}{Value to use to represent the \code{NULL} type. Must be of length 1.}

\item{envir}{The \code{environment} in which to evaluate the arguments. If \code{NULL}, the environment associated with the object is used. If not available, the \code{parent.frame()} is used.}
}
\value{
A single-row \code{data.frame} where each columns represents an argument call or evaluation.
}
\description{
Converts the arguments of a \code{lcMethod} to a named \code{list} of \link{atomic} types.
}
\seealso{
Other lcMethod functions: 
\code{\link{[[,lcMethod-method}},
\code{\link{as.data.frame.lcMethods}()},
\code{\link{as.lcMethods}()},
\code{\link{as.list.lcMethod}()},
\code{\link{evaluate.lcMethod}()},
\code{\link{formula.lcMethod}()},
\code{\link{lcMethod-class}},
\code{\link{update.lcMethod}()}
}
\concept{lcMethod functions}
