% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{latrend-parallel}
\alias{latrend-parallel}
\title{Parallel computing using latrend}
\description{
The model estimation functions support parallel computation through the use of the \link[foreach]{foreach} mechanism.
In order to make use of parallel execution, a parallel back-end must be registered.
}
\section{Windows}{

On Windows, the \link[parallel]{parallel-package} can be used to define parallel socket workers.
\preformatted{
nCores = parallel::detectCores(logical = FALSE)
cl = parallel::makeCluster(nCores - 1)
parallel::clusterEvalQ(cl, expr=library(latrend))
}

Then, register the cluster as the parallel back-end using the \code{doParallel} package:
\preformatted{
doParallel::registerDoParallel(cl)
}

If you defined your own \code{lcMethod} or \code{lcModel} extension classes, make sure to load them on the workers as well.
This can be done, for example, using:
\preformatted{
parallel::clusterEvalQ(cl,
  expr = setClass('lcMethodMyImpl', contains = "lcMethod"))
}
}

\section{Unix}{

On Unix systems, it is easier to setup parallelization as the R process is forked.
In this example we use the \code{doMC} package:
\preformatted{
nCores = parallel::detectCores(logical = FALSE)
doMC::registerDoMC(nCores - 1)
}
}

\seealso{
\link{latrendRep}, \link{latrendBatch}, \link{latrendBoot}, \link{latrendCV}
}
