# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' lasvmTrainWrapper
#' 
#' Use lasvm to train a given problem.
#'
#'  @param	x		data matrix 
#'  @param	y		training labels
#'  @param	gamma	RBF kernel bandwidth
#'  @param	cost		regularization constant
#'   @param  degree 	degree for poly kernel
#'   @param  coef0 	coefficient for poly kernel
#'   @param  optimizer 	type of optimizer
#'   @param  kernel 	kernel type
#'   @param  selection 	selection strategy
#'   @param  termination 	criterion for stopping
#'   @param	sample	parameter for stopping criterion, e.g. seconds
#'   @param  cachesize 	size of kernel cache
#'   @param  bias		use  bias?
#'   @param  epochs 	number of epochs
#'   @param epsilon 	stopping criterion parameter
#'   @param	verbose		verbose output?
#'
#'  @return	a list consisting of
#'	SV		matrix of support vectors
#'	alpha		vector of alpha coefficients
#'	bias		bias term
lasvmTrainWrapper <- function(x, y, gamma, cost, degree = 3, coef0 = 0L, optimizer = 1L, kernel = 2L, selection = 0L, termination = 0L, sample = 0, cachesize = 256L, bias = 1L, epochs = 1L, epsilon = 0.001, verbose = FALSE) {
    .Call('lasvmR_lasvmTrainWrapper', PACKAGE = 'lasvmR', x, y, gamma, cost, degree, coef0, optimizer, kernel, selection, termination, sample, cachesize, bias, epochs, epsilon, verbose)
}

#' lasvmPredictWrapper
#' 
#' Use lasvm to predict a given problem.
#'
#'  @param	x		data matrix 
#'  @param	SV		matrix of support vectors
#'  @param	elif		vector of alphas
#'  @param	gamma		gamma of RBF kernel 
#'  @param	kdegree	degree for POLY kernel
#'  @param	kcoef0		coef0 for kernel
#'  @param	bias		bias term
#'  @param	kerneltype		type of kernel to use
#'  @param	verbose		verbose output?
#'
#'  @return	a list consisting of
#'	predictions		just the predictions
#'
lasvmPredictWrapper <- function(x, SV, elif, gamma, kdegree, kcoef0, bias, kerneltype, verbose = FALSE) {
    .Call('lasvmR_lasvmPredictWrapper', PACKAGE = 'lasvmR', x, SV, elif, gamma, kdegree, kcoef0, bias, kerneltype, verbose)
}

