% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{is_url}
\alias{is_url}
\alias{is_ip}
\alias{are_id}
\alias{are_constant}
\alias{are_binary}
\title{Check if input is_* or are_*}
\usage{
is_url(x, ...)

is_ip(x, ...)

are_id(x)

are_constant(x)

are_binary(x)
}
\arguments{
\item{x}{Vector}

\item{...}{Additional parameters passed to \code{grepl()}}
}
\value{
\code{is_url}. Boolean. Result of checking if \code{x} is a valid URL string.

\code{is_ip}. Boolean. Result of checking if \code{x} is a valid IP string.

\code{are_id}. Boolean. Result of checking if \code{x} is a potential ID vector

\code{are_constant}. Boolean. Result of checking if \code{x} is a constant vector

\code{are_binary}. Boolean. Result of checking if \code{x} is a binary vector
}
\description{
Check whether a value or vector is or is not following a set
of rules. For example: is an URL, is an ID vector, are non-variant or
constant values, are binary values... Notice that \code{is_} will return
the result for each observation and \code{are_} for the whole vector.
}
\examples{
is_url(c("google.com", "http://google.com"))

is_ip(c("163.114.132.0", "7.114.132", "0.0.0.0", "1.1.1.1."))

are_id(1:10)
are_id(LETTERS[1:10])

are_constant(rep(1, 10))
are_constant(1:10)

are_binary(c("A", "B", "A"))
}
