% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missings.R
\name{missingness}
\alias{missingness}
\title{Calculate and Visualize Missingness}
\usage{
missingness(df, plot = FALSE, full = FALSE, subtitle = NA, summary = TRUE)
}
\arguments{
\item{df}{Dataframe. Dataframe to study}

\item{plot}{Boolean. Do you wish to plot results?}

\item{full}{Boolean. Return all variables (or only with missings)?}

\item{subtitle}{Character. Subtitle to show in plot}

\item{summary}{Boolean. Show numerical summary text?}
}
\value{
data.frame with each variable, number of missing values and percentage.
If \code{plot=TRUE}, a plot with the same information reflected.
}
\description{
This function lets the user calculate the percentage of NAs or
missingness in a data.frame. It also plots the results if needed.
}
\examples{
Sys.unsetenv("LARES_FONT") # Temporal

# Dummy data
df <- data.frame(
  A = c(1:5),
  B = c(NA, NA, 1, 1, 1),
  C = rep(NA, 5),
  D = c(NA, LETTERS[1:4])
)

# Missing values summary
missingness(df)

# Visual results

missingness(df, plot = TRUE)

# Show all variables (including those with no missing values)
missingness(df, plot = TRUE, full = TRUE)
}
\seealso{
Other Exploratory: 
\code{\link{corr_cross}()},
\code{\link{corr_var}()},
\code{\link{crosstab}()},
\code{\link{df_str}()},
\code{\link{distr}()},
\code{\link{freqs_df}()},
\code{\link{freqs_list}()},
\code{\link{freqs_plot}()},
\code{\link{freqs}()},
\code{\link{lasso_vars}()},
\code{\link{plot_cats}()},
\code{\link{plot_df}()},
\code{\link{plot_nums}()},
\code{\link{tree_var}()}

Other Missing Values: 
\code{\link{impute}()}
}
\concept{Exploratory}
\concept{Missing Values}
