% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_functions.R
\name{grepm}
\alias{grepm}
\title{Pattern Matching for Any or All Multiple Matches}
\usage{
grepm(pattern, x, type = "all", ...)
}
\arguments{
\item{pattern}{character string containing a \link[base]{regular expression}
    (or character string for \code{fixed = TRUE}) to be matched
    in the given character vector.  Coerced by
    \code{\link[base]{as.character}} to a character string if possible.  If a
    character vector of length 2 or more is supplied, the first element
    is used with a warning.  Missing values are allowed except for
    \code{regexpr}, \code{gregexpr} and \code{regexec}.}

\item{x}{a character vector where matches are sought, or an
    object which can be coerced by \code{as.character} to a character
    vector.  \link[base]{Long vectors} are supported.}

\item{type}{Character. Type of match. Choose one of:
\code{any}, \code{all}}

\item{...}{Additional arguments to pass to \code{grepl}}
}
\value{
Boolean of same length as \code{x}
}
\description{
This function returns a boolean vector of the same length as `x`,
each element of which is the result of applying the `type` of matches
to the corresponding element of `x`, using regular expressions.
}
\examples{
x <- c(123, 876, 18761)
patterns <- c(1, 2)
grepm(patterns, x, type = "any")
grepm(patterns, x, type = "all")
}
