% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facebook.R
\name{fb_creatives}
\alias{fb_creatives}
\title{Facebook Creatives API}
\usage{
fb_creatives(token, which, api_version = "v12.0", process = TRUE)
}
\arguments{
\item{token}{Character. Valid access token with sufficient privileges. Visit the
\href{https://developers.facebook.com/tools/explorer}{Facebook API Graph Explorer}
to acquire one.}

\item{which}{Character vector. This is the accounts, campaigns, adsets,
or ads IDs to be queried. Remember: if \code{report_level = "account"}, you must
start the ID with \code{act_}.}

\item{api_version}{Character. Facebook API version}

\item{process}{Boolean. Process GET results to a more friendly format?}
}
\value{
data.frame with un-nested processed results if \code{process=TRUE} or
raw API results as list when \code{process=FALSE}.
}
\description{
For more information: \href{https://developers.facebook.com/docs/marketing-api/reference/ad-creative/}{Ad Creative}
}
\examples{
\dontrun{
token <- YOURTOKEN
which <- act_ADACCOUNT

# Query all creatives for "which"
creatives <- fb_creatives(YOURTOKEN, which)
}
}
\seealso{
Other API: 
\code{\link{bring_api}()},
\code{\link{fb_accounts}()},
\code{\link{fb_ads}()},
\code{\link{fb_insights}()},
\code{\link{fb_posts}()},
\code{\link{fb_post}()},
\code{\link{fb_process}()},
\code{\link{fb_rf}()},
\code{\link{fb_token}()},
\code{\link{li_auth}()},
\code{\link{li_profile}()},
\code{\link{queryGA}()},
\code{\link{slackSend}()}

Other Facebook: 
\code{\link{fb_accounts}()},
\code{\link{fb_ads}()},
\code{\link{fb_insights}()},
\code{\link{fb_posts}()},
\code{\link{fb_post}()},
\code{\link{fb_process}()},
\code{\link{fb_rf}()},
\code{\link{fb_token}()}
}
\concept{API}
\concept{Facebook}
