% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapley.R
\name{shap_var}
\alias{shap_var}
\title{SHAP-based dependence plots for categorical/numerical features (PDP)}
\usage{
shap_var(x, var, keep_outliers = FALSE)
}
\arguments{
\item{x}{\code{h2o_shap} object}

\item{var}{Variable name}

\item{keep_outliers}{Boolean. Outliers detected with z-score and 3sd
may be suppress or kept in your plot. Keep them?}
}
\value{
ggplot2 objct with shap values plotted
}
\description{
Having a \code{h2o_shap} object, plot a dependence plot for any
categorical or numerical feature.
}
\examples{
\dontrun{
# Train a h2o_automl model
model <- h2o_automl(dft, Survived,
  max_models = 1, target = TRUE,
  ignore = c("Ticket", "Cabin", "PassengerId"),
  quiet = TRUE
)

# Calculate SHAP values
SHAP_values <- h2o_shap(model)
# Equivalent to:
# SHAP_values <- h2o_shap(
#  model = model$model,
#  test = model$datasets$test,
#  scores = model$scores_test$scores)

# Check SHAP results
head(SHAP_values)

# You must have "ggbeeswarm" library to use this auxiliary function:
# Plot SHAP values (feature importance)
plot(SHAP_values)

# Plot some of the variables (categorical)
shap_var(SHAP_values, Pclass)

# Plot some of the variables (numerical)
shap_var(SHAP_values, Fare)
}
}
\seealso{
Other SHAP: 
\code{\link{h2o_shap}()}
}
\concept{SHAP}
