% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demo_landsepi.R
\name{demo_landsepi}
\alias{demo_landsepi}
\title{Package demonstration}
\usage{
demo_landsepi(
  seed = 5,
  strat = "MO",
  Nyears = 10,
  nTSpY = 120,
  videoMP4 = FALSE
)
}
\arguments{
\item{seed}{an interger used as seed for Random Number Generator (default 12345).}

\item{strat}{a string specifying the deployment strategy: "MO" for mosaic of resistant
cultivars, "MI" for intra-fied mixtures, "RO" for cultivar rotations, and "PY" for
resistance gene pyramiding in a cultivar.}

\item{Nyears}{number of cropping seasons (years) to simulate.}

\item{nTSpY}{number of time-steps (days) per cropping season.}

\item{videoMP4}{a logical indicating if a video must be generated (TRUE, default) or not (FALSE).}
}
\value{
A set of text files, graphics and a video showing epidemic dynamics.
}
\description{
run a simulation demonstration with landsepi
}
\details{
In these examples on rust fungi of cereal crops, 2 completely efficient resistance sources
(typical of major resistance genes) are deployed in the landscape according
to one of the following strategies:\itemize{
\item Mosaic: 3 pure crops (S + R1 + R2) with very high spatial aggregation.
\item Mixture: 1 pure susceptible crop + 1 mixture of two resistant cultivars, with high aggregation.
\item Rotation: 1 susceptible pure crop + 2 resistant crops in alternation every 2 years
, with moderate aggregation.
\item Pyramiding: 1 susceptible crop + 1 pyramided cultivar in a fragmented landscape (low aggregation).
}
}
\examples{
\dontrun{
## Run demonstrations (in 10-year simulations) for different deployment strategies:
demo_landsepi(strat = "MO") ## for a mosaic of cultivars
demo_landsepi(strat = "MI") ## for a mixture of cultivars
demo_landsepi(strat = "RO") ## for a rotation of cultivars
demo_landsepi(strat = "PY") ## for a pyramid of resistance genes
}
}
\seealso{
\link{runSimul}, \link{runShinyApp}
}
