% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simul_landsepi.R
\name{simul_landsepi}
\alias{simul_landsepi}
\title{Simulation with provided data}
\usage{
simul_landsepi(seed = 12345, nYears = 5, nTSpY = 120, idLan = 1,
  propSR = 2/3, isolSR = 1, propRR = 1/2, isolRR = 1,
  strat = "MO", Nhost = 3, pI0 = 5e-04, resistance1 = c(1, 0, 0, 0,
  0, 0, 0, 0), resistance2 = c(0, 1, 0, 0, 0, 0, 0, 0),
  costInfect = 0.75, costAggr = 0.75, taumut = 1e-07, probSex = 0,
  MGeff = 1, QReff = 0.5, beta = 1, Naggr = 6, timeToQR_exp = 0,
  timeToQR_var = 0, C0 = rep(0.1, Nhost), Cmax = rep(2, Nhost),
  yield = cbind(H = rep(1/(120 * 1000), Nhost), L = rep(0, Nhost), I =
  rep(0, Nhost), R = rep(0, Nhost)), purchPrice = rep(0.001, Nhost),
  sellPrice = rep(0.2, Nhost), graphic = TRUE, video = FALSE)
}
\arguments{
\item{seed}{an integer used as seed value (for random number generator).}

\item{nYears}{an integer giving the number of simulated years.}

\item{nTSpY}{an integer giving the number of time steps per year.}

\item{idLan}{an integer giving the index of landscape structure (1 to 5).}

\item{propSR}{proportion of fields where resistance is deployed: (RC)/(SC+RC) or (RC1+RC2)/(SC+RC1+RC2). Must be between 0 and 1.}

\item{isolSR}{an integer giving the spatial aggregation of fields where resistance is deployed (1=highly fragmented, 2=balanced, 3=highly aggregated).}

\item{propRR}{when applicable (mixtures and mosaics only), relative proportion of the second resistant cultivar: (RC2)/(RC1+RC2). Must be between 0 and 1.}

\item{isolRR}{when applicable, an integer specifying the spatial (for mosaics: 1=highly fragmented, 2=balanced, 3=highly aggregated) or 
temporal (for rotations: 1=every year, 2=every two years, 3=every three years) aggregation of fields cultivated with the second resistant cultivar.}

\item{strat}{a character string specifying the deployment strategy ("MO"=mosaic, "MI"=mixture, "RO"=rotations, "PY"=pyramiding).}

\item{Nhost}{an integer giving the number of cultivars (1, 2 or 3).}

\item{pI0}{initial probability of infection of the susceptible cultivar. Must be between 0 and 1.}

\item{resistance1}{a logical vector of size 8 giving the resistance formula of the 2nd cultivar (see details)}

\item{resistance2}{when applicable, a logical vector of size 8 giving the resistance formula of the 3rd cultivar (see details)}

\item{costInfect}{cost of infectivity paid by infective pathogens (i.e. adapted to plant cultivars carrying a major gene) on susceptible hosts. Must be between 0 and 1.}

\item{costAggr}{cost of aggressiveness paid by fully adapted pathogens (relative to plant cultivars carrying a quantitative resistance trait) on fully susceptible hosts. Must be between 0 and 1.}

\item{taumut}{mutation probability: probability for a propagule to change its infectivity or its aggressiveness on a resistant cultivar 
carrying a major gene or a quantitative resistance trait. Must be above 0. If equal to 0, then the pathogen cannot evolve.}

\item{probSex}{probability for an infection that its reproduction is sexual rather than clonal.}

\item{MGeff}{efficiency of major-gene resistance on the infection rate of non-adapted pathogens. Must be between 0 and 1.}

\item{QReff}{efficiency of quantitative resistance on the target aggressiveness trait (infection rate, latent period duration, 
sporulation rate, or sporulation duration) of non-adapted pathogens. Must be between 0 and 1.}

\item{beta}{trade-off strength for pathogen adaptation to quantitative resistance (<1 for weak, =1 for linear, >1 for strong). Must be above 0.}

\item{Naggr}{an integer specifying the number of increments to completely adapt to quantitative resistance. Must be greater or equal 2.}

\item{timeToQR_exp}{average time to expression of quantitative resistance (to simulate Adult Plant Resistance).}

\item{timeToQR_var}{variance of the time to expression of quantitative resistance (to simulate Adult Plant Resistance).}

\item{C0}{planting density of the different cultivars (in number of hosts per meter square).}

\item{Cmax}{carrying capacity of the different cultivars (in number of hosts per meter square).}

\item{yield}{a matrix of yield (weight units of product/individual/time-step) for each cultivar (rows) and each sanitary state (columns: H, L, I, R).}

\item{purchPrice}{price of crop planting (in monetary units/planted individual)}

\item{sellPrice}{selling price (in monetary unit/weight units of production)}

\item{graphic}{a logical indicating if graphics must be generated (TRUE) or not (FALSE).}

\item{video}{a logical indicating if a video must be generated (TRUE) or not (FALSE). Works only if graphic is TRUE as well.}
}
\value{
A set of binary files is generated for every year of simulation and every compartment: \itemize{
\item H: healthy hosts,
\item Hjuv: juvenile healthy hosts,
\item L: latently infected hosts,
\item I: infectious hosts,
\item R: removed hosts,
\item S: propagules.
} 
Each file indicates for every time-step the number of individuals in each field, and when appropriate for each cultivar and pathotype)
These binary files are used to generate a set of text files containing all outputs of the simulations (see details).
A set of graphics and a video showing epidemic maps can also be generated.
}
\description{
Simulation of plant resistance deployment, using landscape structures provided with the package
and a parameterisation of the model to represent pathogens as typified by rusts of cereals (e.g. stripe rust, stem rust
, and leaf rust of wheat and barley). All parameters are optional. See details for explanations.
}
\details{
\describe{

\item{Landscape structure}{The landscape structure is the physical structure of the area, defined as the spatial arrangement of fields.}

\item{Deployment strategies}{Deployment strategies include the deployment of a susceptible cultivar (SC)
and one (RC) or two (RC1 and RC2) resistant cultivars carrying up to four major resistance genes or up to four
quantitative resistance traits (against infection rate, latent period, sporulation rate and sporulation duration 
of the pathogen). In addition, the different resistance sources can be combined in time (crop rotation: recurrent
succession of cultivars in the same field), or space within a single cultivar (pyramiding), in different cultivars
of the same field (mixtures) or in different fields (mosaics).}

\item{Resistance formulas}{The genetic resistance carried by a plant cultivar is specified by a vector of size 8: the
four first elements indicate whether the cultivar carries major resistance genes #1, #2, #3 and #4, respectively.
The following four elements indicate whether the cultivar carried a quantitative resistance trait against the
 infection rate, the latent period duration, the sporulation rate, or the sporulation duration of the pathogen, respectively.
 For example, the formula c(1,0,0,0,0,1,0,0) indicates the presence of major gene #1 and a quantitative resistance which 
 increases the duration of the latent period of the pathogen.}

\item{Model outputs}{ 

\describe{
\item{\strong{Evolutionary outputs.}}{ \describe{
\item{\emph{Durability of qualitative resistance:}}{
For a given major gene, several computations are 
performed: \itemize{
\item (d1) time to first appearance of a pathogen mutant;
\item (d2) time to first true infection of a resistant host by such mutants; and 
\item (d3) time when the number of infections of resistant hosts by these mutants reaches a threshold above which mutant pathogens are unlikely to go extinct.
} 
}
\item{\emph{Erosion of quantitative resistance:}}{
pathogen adaptation to quantitative resistance is gradual, so the three measures described above are computed for every step 
towards complete erosion of resistance (i.e. nAgw-1 levels).} 
\item{\emph{Durability of a deployment strategy:}}{ a simulation run is divided into three periods: \enumerate{
\item the initial short-term period when all resistance sources are at their highest potential; 
\item a transitory period during which a given deployment strategy is only partially effective; and 
\item a longer-term period when all the resistances have been overcome or completely eroded. 
}
To assess the end of the short-term period, the time to establishment (durability measure (d3)) is computed for every major gene, and every quantitative trait 
at the first level of erosion (agw(p)=2). The minimal value of these measures, denoted by D1, delimitates short-term and transitory periods. 
Similarly, the time to establishment is computed for every major gene, and for every quantitative trait at the highest level of erosion (agw(p)=nAgw). 
The maximal value of these measures, termed D2, delimits transitory and long-term periods.
}
}
}
\item{\strong{Epidemiological outputs.}}{ 
The epidemiological impact of pathogen spread is evaluated by two different measures: \enumerate{
\item Green Leaf Area (GLA): The GLA represents the average number of productive hosts per time step and per surface unit.
\item Area Under Disease Progress Curve (AUDPC): The AUDPC is the average proportion of diseased hosts relative to the carrying capacity and represents disease severity.
}
\describe{
\item{\emph{Global epidemiological control:}}{
The GLA and AUDPC of every cultivar as well as the whole landscape are averaged across the whole simulation run, 
 to measure the global epidemiological performance of a deployment strategy.} 
 \item{\emph{Short-term epidemiological control:}}{
  The average GLA and AUDPC of the susceptible 
 cultivar is computed on whole cropping seasons from the beginning of the simulation until the end of 
 the season preceding year before D1.}
 \item{\emph{Epidemiological control during the transitory period:}}{
 The average GLA and AUDPC of the susceptible cultivar is computed on whole seasons from the 
 beginning of the season following year after D1 to the end of the season year before preceding D2.} 
 \item{\emph{Long-term epidemiological control:}}{
 The average GLA and AUDPC of the whole landscape is computed on whole seasons 
 from the beginning of the year after D2 to the end of the simulation.}
 }
 }
 }
}
}
}
\examples{
\donttest{
## Default parameterisation (5-year simulation of a mosaic deployment strategy of 
## two resistant cultivars in balanced proportions and low level of spatial aggregation)
simul_landsepi()

## Mosaic of two major genes
simul_landsepi(seed=1, idLan=1, propSR=2/3, isolSR=3, propRR=1/2, isolRR=3, strat="MO", Nhost=3
, nYears=50, resistance1=c(1,0,0,0,0,0,0,0), resistance2=c(0,1,0,0,0,0,0,0)
, costInfect=0.5, taumut=1e-7)

## Mixture of two major genes
simul_landsepi(seed=1, idLan=1, propSR=2/3, isolSR=3, propRR=1/2, strat="MI", Nhost=3
, nYears=50, resistance1=c(1,0,0,0,0,0,0,0), resistance2=c(0,1,0,0,0,0,0,0)
, costInfect=0.5, taumut=1e-7)

## Rotations of two major genes
simul_landsepi(seed=1, idLan=1, propSR=2/3, isolSR=3, isolRR=1, strat="RO", Nhost=3
, nYears=50, resistance1=c(1,0,0,0,0,0,0,0), resistance2=c(0,1,0,0,0,0,0,0)
, costInfect=0.5, taumut=1e-7)

## Pyramiding of two major genes
simul_landsepi(seed=1, idLan=1, propSR=2/3, isolSR=3, strat="PY", Nhost=2
, nYears=50, resistance1=c(1,1,0,0,0,0,0,0), costInfect=0.5, taumut=1e-7)

## Combination of a major gene with a quantitative resistance against the latent period    
simul_landsepi(seed=1, idLan=1, propSR=0.8, isolSR=1, strat="PY", Nhost=2
, nYears=50, resistance1=c(1,0,0,0,0,1,0,0)
, costInfect=0.5, costAggr=0.5, taumut=1e-7, MGeff=1.0, QReff=0.5, beta=1.0, Naggr=6)
}
}
\references{
Rimbaud L., Papaïx J., Rey J.-F., Barrett L. G. and Thrall P. H. (2018). Assessing the durability and efficiency of landscape-based strategies to deploy plant resistance to pathogens. \emph{PLoS Computational Biology} 14(4):e1006067.
}
