#' util_rescale
#'
#' Linearly rescale element values in a raster to a range between 0 and 1.
#'
#' @param x Raster* object
#'
#' @return Raster* object with values ranging from 0-1
#'
#' @details Rasters generated by \code{nlm_} functions are scaled between 0 and 1 as default, this option can be set to \code{FALSE} if needed.
#'
#' @examples
#' unscmap <- util_merge(grdmap, rndmap, rescale = FALSE)
#' util_rescale(unscmap)
#'
#'
#' @aliases util_rescale
#' @rdname util_rescale
#'
#' @export
#'

util_rescale <- function(x) {
  rescaled_NLM <-
    (x - raster::cellStats(x, "min")) /
      (raster::cellStats(x, "max") - raster::cellStats(x, "min"))

  return(rescaled_NLM)
}
