% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_sample.R
\name{scale_sample}
\alias{scale_sample}
\title{scale_sample}
\usage{
scale_sample(
  landscape,
  y,
  shape = "square",
  size,
  verbose = TRUE,
  progress = FALSE,
  ...
)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick, SpatRaster (terra), stars, or a list of rasterLayers.}

\item{y}{Point geometry as SpatVector or sf object or 2-column matrix with coordinates.}

\item{shape}{String specifying plot shape. Either "circle" or "square"}

\item{size}{Approximated size of sample plot. Equals the radius for circles or half of
the side-length for squares in mapunits. For lines size equals the width of the buffer.}

\item{verbose}{Print warning messages.}

\item{progress}{Print progress report.}

\item{...}{Arguments passed on to \code{calculate_lsm()}.}
}
\value{
tibble
}
\description{
Metrics on changing sample scale
}
\details{
This function calculates the selected metrics in subsequential buffers around
a/multiple point(s) of interest.

The size of the actual sampled landscape can be different to the provided size
due to two reasons. Firstly, because clipping raster cells using a circle or a
sample plot not directly at a cell center lead to inaccuracies. Secondly,
sample plots can exceed the landscape boundary. Therefore, we report the actual
clipped sample plot area relative in relation to the theoretical, maximum sample
plot area e.g. a sample plot only half within the landscape will have a
\code{percentage_inside = 50}. Please be aware that the output is sligthly different
to all other \code{lsm}-function of \code{landscapemetrics}.

The metrics can be specified by the arguments \code{what}, \code{level}, \code{metric}, \code{name}
and/or \code{type} (combinations of different arguments are possible (e.g.
\verb{level = "class", type = "aggregation metric"}). If an argument is not provided,
automatically all possibilities are selected. Therefore, to get \strong{all}
available metrics, don't specify any of the above arguments.
}
\examples{
my_points <- matrix(c(1265000, 1250000, 1255000, 1257000), ncol = 2, byrow = TRUE)
my_points <- terra::vect(my_points, crs = terra::rast(landscapemetrics::augusta_nlcd))

scale_sample(landscape = terra::rast(landscapemetrics::augusta_nlcd), y = my_points,
size = c(500, 750, 1000), what = c("lsm_l_ent", "lsm_l_mutinf"))

}
\seealso{
\code{\link{list_lsm}} \cr
\code{\link{calculate_lsm}} \cr
\code{\link{sample_lsm}} \cr
\code{\link{construct_buffer}}
}
