% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_cohesion.R
\name{lsm_l_cohesion}
\alias{lsm_l_cohesion}
\title{COHESION (landscape level)}
\usage{
lsm_l_cohesion(landscape, directions = 8)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{directions}{The number of directions in which patches should be connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Patch Cohesion Index (Aggregation metric)
}
\details{
\deqn{COHESION = 1 - (\frac{\sum \limits_{i = 1}^{m} \sum \limits_{j = 1}^{n} p_{ij}} {\sum \limits_{i = 1}^{m} \sum \limits_{j = 1}^{n} p_{ij} \sqrt{a_{ij}}}) * (1 - \frac{1} {\sqrt{Z}}) ^ {-1} * 100}
where \eqn{p_{ij}} is the perimeter in meters, \eqn{a_{ij}} is the area in square
meters and \eqn{Z} is the number of cells.

COHESION is an 'Aggregation metric'.

\subsection{Units}{Percent}
\subsection{Ranges}{Unknown}
\subsection{Behaviour}{Unknown}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_l_cohesion(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org

Schumaker, N. H. 1996. Using landscape indices to predict habitat
connectivity. Ecology, 77(4), 1210-1225.
}
\seealso{
\code{\link{lsm_p_perim}},
\code{\link{lsm_p_area}}, \cr
\code{\link{lsm_l_cohesion}}
}
