% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_extras.R
\name{get_complexity}
\alias{get_complexity}
\title{get_complexity}
\usage{
get_complexity(landscape_mat, neighbourhood, ordered, base)
}
\arguments{
\item{landscape_mat}{A matrix object}

\item{neighbourhood}{The number of directions in which cell adjacencies are considered as neighbours: 4 (rook's case) or 8 (queen's case). The default is 4.}

\item{ordered}{The type of pairs considered. Either ordered (TRUE) or unordered (FALSE).}

\item{base}{The unit in which entropy is measured. The default is "log2",}
}
\value{
matrix
}
\description{
Calculate complexity of the landscape
}
\details{
Calculate complexity of the landscape: entropy of the co-occurrence matrix
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
landscape_mat <- terra::as.matrix(landscape, wide = TRUE)
get_complexity(landscape_mat, neighbourhood = 4, ordered = TRUE, base = "log2")

}
\keyword{internal}
