% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialize_lsm.R
\name{spatialize_lsm}
\alias{spatialize_lsm}
\title{spatialize_lsm}
\usage{
spatialize_lsm(
  landscape,
  level = "patch",
  metric = NULL,
  name = NULL,
  type = NULL,
  what = NULL,
  directions = 8,
  progress = FALSE,
  to_disk = getOption("to_disk", default = FALSE),
  ...
)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{level}{Level of metrics. Either 'patch', 'class' or 'landscape' (or vector with combination).}

\item{metric}{Abbreviation of metrics (e.g. 'area').}

\item{name}{Full name of metrics (e.g. 'core area')}

\item{type}{Type according to FRAGSTATS grouping (e.g. 'aggregation metrics').}

\item{what}{Selected level of metrics: either "patch", "class" or "landscape".
It is also possible to specify functions as a vector of strings, e.g. \code{what = c("lsm_c_ca", "lsm_l_ta")}.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}

\item{progress}{Print progress report.}

\item{to_disk}{If TRUE raster will be saved to disk.}

\item{...}{Arguments passed on to \code{calculate_lsm()}.}
}
\value{
list
}
\description{
Spatialize landscape metric values
}
\details{
The functions returns a nested list with \code{RasterLayer}s. The first level
contains each input layer (only one element if \code{RasterLayer} was provided).
The second level contains a \code{RasterLayer} for each selected metric
(see \code{list_lsm} for details) where each cell has the landscape metric
value of the patch it belongs to. Only patch level metrics are allowed.
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
spatialize_lsm(landscape, what = "lsm_p_area")

}
\seealso{
\code{\link{list_lsm}} \cr
\code{\link{show_lsm}}
}
