% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_circle_cv.R
\name{lsm_c_circle_cv}
\alias{lsm_c_circle_cv}
\title{CIRCLE_CV (Class level)}
\usage{
lsm_c_circle_cv(landscape, directions = 8)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Coefficient of variation of related circumscribing circle (Shape metric)
}
\details{
\deqn{CIRCLE_{CV} = cv(CIRCLE[patch_{ij}])}
where \eqn{CIRCLE[patch_{ij}]} is the related circumscribing circle of each patch.

CIRCLE_CV is a 'Shape metric' and summarises each class as the Coefficient of variation of
the related circumscribing circle of all patches belonging to class i. CIRCLE describes
the ratio between the patch area and the smallest circumscribing circle of the patch
and characterises the compactness of the patch. CIRCLE_CV describes the differences among
patches of the same class i in the landscape. Because it is scaled to the mean,
it is easily comparable.

\subsection{Units}{None}
\subsection{Range}{CIRCLE_CV >= 0}
\subsection{Behaviour}{Equals CIRCLE_CV if the related circumscribing circle is identical
for all patches. Increases, without limit, as the variation of related circumscribing
circles increases.}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_c_circle_cv(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org

Baker, W. L., and Y. Cai. 1992. The r.le programs for multiscale analysis of
landscape structure using the GRASS geographical information system.
Landscape Ecology 7: 291-302.

Based on C++ code from Project Nayuki (https://www.nayuki.io/page/smallest-enclosing-circle).
}
\seealso{
\code{\link{lsm_p_circle}},
\code{\link{mean}}, \cr
\code{\link{lsm_c_circle_mn}},
\code{\link{lsm_c_circle_sd}}, \cr
\code{\link{lsm_l_circle_mn}},
\code{\link{lsm_l_circle_sd}},
\code{\link{lsm_l_circle_cv}}
}
