% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_boundaries.R
\name{get_boundaries}
\alias{get_boundaries}
\title{get_boundaries}
\usage{
get_boundaries(
  landscape,
  consider_boundary = FALSE,
  edge_depth = 1,
  as_NA = FALSE,
  patch_id = FALSE,
  return_raster = TRUE
)
}
\arguments{
\item{landscape}{SpatRaster or matrix.}

\item{consider_boundary}{Logical if cells that only neighbour the landscape
boundary should be considered as edge.}

\item{edge_depth}{Distance (in cells) a cell has the be away from the patch
edge to be considered as core cell.}

\item{as_NA}{If true, non-boundary cells area labeld NA.}

\item{patch_id}{If true, boundary/edge cells are labeled with the original patch id.}

\item{return_raster}{If false, matrix is returned.}
}
\value{
List with RasterLayer or matrix
}
\description{
Get boundary cells of patches
}
\details{
All boundary/edge cells are labeled 1, all non-boundary cells 0. NA values are
not changed. Boundary cells are defined as cells that neighbour either a NA
cell or a cell with a different value than itself. Non-boundary cells only
neighbour cells with the same value than themself.
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
class_1 <- get_patches(landscape, class = 1)[[1]][[1]]

get_boundaries(class_1)
get_boundaries(class_1, return_raster = FALSE)

}
