% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_dcore_mn.R
\name{lsm_c_dcore_mn}
\alias{lsm_c_dcore_mn}
\title{DCORE_MN (class level)}
\usage{
lsm_c_dcore_mn(
  landscape,
  directions = 8,
  consider_boundary = FALSE,
  edge_depth = 1
)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick, SpatRaster (terra), stars, or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}

\item{consider_boundary}{Logical if cells that only neighbour the landscape
boundary should be considered as core}

\item{edge_depth}{Distance (in cells) a cell has the be away from the patch
edge to be considered as core cell}
}
\value{
tibble
}
\description{
Mean number of disjunct core areas (Core area metric)
}
\details{
\deqn{DCORE_{MN} = mean(NCORE[patch_{ij}])}
where \eqn{NCORE[patch_{ij}]} is the number of core areas.

DCORE_MN is an 'Core area metric'. It summarises each class as the mean of all
patch areas belonging to class i. A cell is defined as core if the cell
has no neighbour with a different value than itself (rook's case). NCORE counts the disjunct
core areas, whereby a core area is a 'patch within the patch' containing only core cells.

\subsection{Units}{None}
\subsection{Range}{DCORE_MN > 0}
\subsection{Behaviour}{Equals DCORE_MN = 0 if NCORE = 0 for all patches. Increases,
without limit, as the number of disjunct core areas increases.}
}
\examples{
lsm_c_dcore_mn(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: https://www.umass.edu/landeco/
}
\seealso{
\code{\link{lsm_p_ncore}},
\code{\link{mean}}, \cr
\code{\link{lsm_c_dcore_sd}},
\code{\link{lsm_c_dcore_cv}}, \cr
\code{\link{lsm_l_dcore_mn}},
\code{\link{lsm_l_dcore_sd}},
\code{\link{lsm_l_dcore_cv}}
}
