% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialize_lsm.R
\name{spatialize_lsm}
\alias{spatialize_lsm}
\alias{spatialize_lsm.RasterLayer}
\alias{spatialize_lsm.RasterStack}
\alias{spatialize_lsm.RasterBrick}
\alias{spatialize_lsm.stars}
\alias{spatialize_lsm.list}
\title{spatialize_lsm}
\usage{
spatialize_lsm(landscape, metric, name, type, what, directions, progress,
  ...)

\method{spatialize_lsm}{RasterLayer}(landscape, metric = NULL,
  name = NULL, type = NULL, what = NULL, directions = 8,
  progress = FALSE, ...)

\method{spatialize_lsm}{RasterStack}(landscape, metric = NULL,
  name = NULL, type = NULL, what = NULL, directions = 8,
  progress = FALSE, ...)

\method{spatialize_lsm}{RasterBrick}(landscape, metric = NULL,
  name = NULL, type = NULL, what = NULL, directions = 8,
  progress = FALSE, ...)

\method{spatialize_lsm}{stars}(landscape, metric = NULL, name = NULL,
  type = NULL, what = NULL, directions = 8, progress = FALSE, ...)

\method{spatialize_lsm}{list}(landscape, metric = NULL, name = NULL,
  type = NULL, what = NULL, directions = 8, progress = FALSE, ...)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{metric}{Abbreviation of metrics (e.g. 'area').}

\item{name}{Full name of metrics (e.g. 'core area')}

\item{type}{Type according to FRAGSTATS grouping (e.g. 'aggregation metrics').}

\item{what}{Selected level of metrics: either "patch", "class" or "landscape".
It is also possible to specify functions as a vector of strings, e.g. \code{what = c("lsm_c_ca", "lsm_l_ta")}.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}

\item{progress}{Print progress report.}

\item{...}{Arguments passed on to \code{calculate_lsm()}.}
}
\value{
list
}
\description{
Spatialize landscape metric values
}
\details{
The functions returns a nested list with \code{RasterLayer}s. The first level
contains each input layer (only one element if \code{RasterLayer} was provided).
The second level contains a \code{RasterLayer} for each selected metric
(see \code{list_lsm} for details) where each cell has the landscape metric
value of the patch it belongs to. Only patch level metrics are allowed.
}
\examples{
spatialize_lsm(landscape, what = "lsm_p_area")

}
\seealso{
\code{\link{list_lsm}} \cr
\code{\link{show_lsm}}
}
