% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_nearestneighbour.R
\name{get_nearestneighbour}
\alias{get_nearestneighbour}
\alias{get_nearestneighbour.RasterLayer}
\alias{get_nearestneighbour.matrix}
\title{get_nearestneighbour}
\usage{
get_nearestneighbour(landscape)

\method{get_nearestneighbour}{RasterLayer}(landscape)

\method{get_nearestneighbour}{matrix}(landscape)
}
\arguments{
\item{landscape}{RasterLayer or matrix (with x,y,id columns)}
}
\description{
Calculates the minimal euclidean distance between classes for a raster/matrix.
}
\details{
Fast and memory safe Rcpp implementation for calculating minimal euclidean distances between
classes in a raster or matrix.
}
\examples{
# get patches for class 1 from testdata as raster
class_1 <- get_patches(landscape,1)[[1]]

# calculate the distance between patches
get_nearestneighbour(class_1)

# do the same with a 3 column matrix (x,y,id)
class_1_matrix <- raster::rasterToPoints(class_1)
get_nearestneighbour(class_1_matrix)

}
