% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_lpi.R
\name{lsm_l_lpi}
\alias{lsm_l_lpi}
\alias{lsm_l_lpi.RasterLayer}
\alias{lsm_l_lpi.RasterStack}
\alias{lsm_l_lpi.RasterBrick}
\alias{lsm_l_lpi.list}
\title{LPI (landscape level)}
\usage{
lsm_l_lpi(landscape, directions)

\method{lsm_l_lpi}{RasterLayer}(landscape, directions = 8)

\method{lsm_l_lpi}{RasterStack}(landscape, directions = 8)

\method{lsm_l_lpi}{RasterBrick}(landscape, directions = 8)

\method{lsm_l_lpi}{list}(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Largest patch index (Area and Edge metric)
}
\details{
\deqn{LPI = \frac{\max (a_{ij})} {A} * 100}
where \eqn{max(a_{ij})} is the area of the patch in square meters and \eqn{A}
is the total landscape area in square meters.

The largest patch index is an 'Area and edge metric'. It is the percentage of the
landscape covered by the largest patch in the landscape. It is a simple
measure of dominance.

\subsection{Units}{Percentage}
\subsection{Range}{0 < LPI <= 100}
\subsection{Behaviour}{Approaches LPI = 0 when the largest patch is becoming small
and equals LPI = 100 when only one patch is present}
}
\examples{
lsm_l_lpi(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html
}
\seealso{
\code{\link{lsm_p_area}},
\code{\link{lsm_l_ta}}, \cr
\code{\link{lsm_c_lpi}}
}
