% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_mesh.R
\name{lsm_l_mesh}
\alias{lsm_l_mesh}
\alias{lsm_l_mesh.RasterLayer}
\alias{lsm_l_mesh.RasterStack}
\alias{lsm_l_mesh.RasterBrick}
\alias{lsm_l_mesh.list}
\title{MESH (landscape level)}
\usage{
lsm_l_mesh(landscape, directions)

\method{lsm_l_mesh}{RasterLayer}(landscape, directions = 8)

\method{lsm_l_mesh}{RasterStack}(landscape, directions = 8)

\method{lsm_l_mesh}{RasterBrick}(landscape, directions = 8)

\method{lsm_l_mesh}{list}(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Effective Mesh Size (Aggregation metric)
}
\details{
\deqn{MESH = \frac{\sum \limits_{i = 1}^{m} \sum \limits_{j = 1}^{n} a_{ij} ^ 2}{A} * \frac{1} {10000}}
where \eqn{a_{ij}} is the patch area in square meters and \eqn{A} is the
total landscape area in square meters.

The effective mesh size is an 'Aggregation metric'. Because each patch is squared
before the sum is calculated and the sum is standardized by the
total landscape area, MESH is a relative measure of patch structure. MESH is
perfectly, negatively correlated to \code{\link{lsm_c_division}}.

\subsection{Units}{Hectares}
\subsection{Range}{cell size / total area <= MESH <= total area}
\subsection{Behaviour}{Equals cellsize/total area if class covers only
one cell and equals total area if only one patch is present.}
}
\examples{
lsm_l_mesh(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html

Jaeger, J. A. 2000. Landscape division, splitting index, and effective mesh
size: new measures of landscape fragmentation.
Landscape ecology, 15(2), 115-130.
}
\seealso{
\code{\link{lsm_p_area}},
\code{\link{lsm_l_ta}}, \cr
\code{\link{lsm_c_mesh}}
}
